package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for iOS Volume-Purchased Program (Vpp) Licensing Type.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "supportDeviceLicensing", 
    "supportsDeviceLicensing", 
    "supportsUserLicensing", 
    "supportUserLicensing"})
@JsonInclude(Include.NON_NULL)
public class VppLicensingType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("supportDeviceLicensing")
    protected Boolean supportDeviceLicensing;

    @JsonProperty("supportsDeviceLicensing")
    protected Boolean supportsDeviceLicensing;

    @JsonProperty("supportsUserLicensing")
    protected Boolean supportsUserLicensing;

    @JsonProperty("supportUserLicensing")
    protected Boolean supportUserLicensing;

    protected VppLicensingType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vppLicensingType";
    }

    /**
     * <i>“Whether the program supports the device licensing type.”</i>
     * 
     * @return property supportDeviceLicensing
     */
    @Property(name="supportDeviceLicensing")
    @JsonIgnore
    public Optional<Boolean> getSupportDeviceLicensing() {
        return Optional.ofNullable(supportDeviceLicensing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportDeviceLicensing} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether the program supports the device licensing type.”</i>
     * 
     * @param supportDeviceLicensing
     *            new value of {@code supportDeviceLicensing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportDeviceLicensing} field changed
     */
    public VppLicensingType withSupportDeviceLicensing(Boolean supportDeviceLicensing) {
        VppLicensingType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppLicensingType");
        _x.supportDeviceLicensing = supportDeviceLicensing;
        return _x;
    }

    /**
     * <i>“Whether the program supports the device licensing type.”</i>
     * 
     * @return property supportsDeviceLicensing
     */
    @Property(name="supportsDeviceLicensing")
    @JsonIgnore
    public Optional<Boolean> getSupportsDeviceLicensing() {
        return Optional.ofNullable(supportsDeviceLicensing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportsDeviceLicensing} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether the program supports the device licensing type.”</i>
     * 
     * @param supportsDeviceLicensing
     *            new value of {@code supportsDeviceLicensing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportsDeviceLicensing} field changed
     */
    public VppLicensingType withSupportsDeviceLicensing(Boolean supportsDeviceLicensing) {
        VppLicensingType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppLicensingType");
        _x.supportsDeviceLicensing = supportsDeviceLicensing;
        return _x;
    }

    /**
     * <i>“Whether the program supports the user licensing type.”</i>
     * 
     * @return property supportsUserLicensing
     */
    @Property(name="supportsUserLicensing")
    @JsonIgnore
    public Optional<Boolean> getSupportsUserLicensing() {
        return Optional.ofNullable(supportsUserLicensing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportsUserLicensing} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether the program supports the user licensing type.”</i>
     * 
     * @param supportsUserLicensing
     *            new value of {@code supportsUserLicensing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportsUserLicensing} field changed
     */
    public VppLicensingType withSupportsUserLicensing(Boolean supportsUserLicensing) {
        VppLicensingType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppLicensingType");
        _x.supportsUserLicensing = supportsUserLicensing;
        return _x;
    }

    /**
     * <i>“Whether the program supports the user licensing type.”</i>
     * 
     * @return property supportUserLicensing
     */
    @Property(name="supportUserLicensing")
    @JsonIgnore
    public Optional<Boolean> getSupportUserLicensing() {
        return Optional.ofNullable(supportUserLicensing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportUserLicensing} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether the program supports the user licensing type.”</i>
     * 
     * @param supportUserLicensing
     *            new value of {@code supportUserLicensing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportUserLicensing} field changed
     */
    public VppLicensingType withSupportUserLicensing(Boolean supportUserLicensing) {
        VppLicensingType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppLicensingType");
        _x.supportUserLicensing = supportUserLicensing;
        return _x;
    }

    public VppLicensingType withUnmappedField(String name, Object value) {
        VppLicensingType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean supportDeviceLicensing;
        private Boolean supportsDeviceLicensing;
        private Boolean supportsUserLicensing;
        private Boolean supportUserLicensing;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether the program supports the device licensing type.”</i>
         * 
         * @param supportDeviceLicensing
         *            value of {@code supportDeviceLicensing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportDeviceLicensing(Boolean supportDeviceLicensing) {
            this.supportDeviceLicensing = supportDeviceLicensing;
            this.changedFields = changedFields.add("supportDeviceLicensing");
            return this;
        }

        /**
         * <i>“Whether the program supports the device licensing type.”</i>
         * 
         * @param supportsDeviceLicensing
         *            value of {@code supportsDeviceLicensing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportsDeviceLicensing(Boolean supportsDeviceLicensing) {
            this.supportsDeviceLicensing = supportsDeviceLicensing;
            this.changedFields = changedFields.add("supportsDeviceLicensing");
            return this;
        }

        /**
         * <i>“Whether the program supports the user licensing type.”</i>
         * 
         * @param supportsUserLicensing
         *            value of {@code supportsUserLicensing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportsUserLicensing(Boolean supportsUserLicensing) {
            this.supportsUserLicensing = supportsUserLicensing;
            this.changedFields = changedFields.add("supportsUserLicensing");
            return this;
        }

        /**
         * <i>“Whether the program supports the user licensing type.”</i>
         * 
         * @param supportUserLicensing
         *            value of {@code supportUserLicensing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportUserLicensing(Boolean supportUserLicensing) {
            this.supportUserLicensing = supportUserLicensing;
            this.changedFields = changedFields.add("supportUserLicensing");
            return this;
        }

        public VppLicensingType build() {
            VppLicensingType _x = new VppLicensingType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vppLicensingType";
            _x.supportDeviceLicensing = supportDeviceLicensing;
            _x.supportsDeviceLicensing = supportsDeviceLicensing;
            _x.supportsUserLicensing = supportsUserLicensing;
            _x.supportUserLicensing = supportUserLicensing;
            return _x;
        }
    }

    private VppLicensingType _copy() {
        VppLicensingType _x = new VppLicensingType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.supportDeviceLicensing = supportDeviceLicensing;
        _x.supportsDeviceLicensing = supportsDeviceLicensing;
        _x.supportsUserLicensing = supportsUserLicensing;
        _x.supportUserLicensing = supportUserLicensing;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VppLicensingType[");
        b.append("supportDeviceLicensing=");
        b.append(this.supportDeviceLicensing);
        b.append(", ");
        b.append("supportsDeviceLicensing=");
        b.append(this.supportsDeviceLicensing);
        b.append(", ");
        b.append("supportsUserLicensing=");
        b.append(this.supportsUserLicensing);
        b.append(", ");
        b.append("supportUserLicensing=");
        b.append(this.supportUserLicensing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
