package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.VpnTrafficRuleAppType;
import odata.msgraph.client.beta.enums.VpnTrafficRuleRoutingPolicyType;


/**
 * <i>“VPN Traffic Rule definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "appType", 
    "claims", 
    "localAddressRanges", 
    "localPortRanges", 
    "name", 
    "protocols", 
    "remoteAddressRanges", 
    "remotePortRanges", 
    "routingPolicyType"})
@JsonInclude(Include.NON_NULL)
public class VpnTrafficRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("appType")
    protected VpnTrafficRuleAppType appType;

    @JsonProperty("claims")
    protected String claims;

    @JsonProperty("localAddressRanges")
    protected List<IPv4Range> localAddressRanges;

    @JsonProperty("localAddressRanges@nextLink")
    protected String localAddressRangesNextLink;

    @JsonProperty("localPortRanges")
    protected List<NumberRange> localPortRanges;

    @JsonProperty("localPortRanges@nextLink")
    protected String localPortRangesNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("protocols")
    protected Integer protocols;

    @JsonProperty("remoteAddressRanges")
    protected List<IPv4Range> remoteAddressRanges;

    @JsonProperty("remoteAddressRanges@nextLink")
    protected String remoteAddressRangesNextLink;

    @JsonProperty("remotePortRanges")
    protected List<NumberRange> remotePortRanges;

    @JsonProperty("remotePortRanges@nextLink")
    protected String remotePortRangesNextLink;

    @JsonProperty("routingPolicyType")
    protected VpnTrafficRuleRoutingPolicyType routingPolicyType;

    protected VpnTrafficRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnTrafficRule";
    }

    /**
     * <i>“App identifier, if this traffic rule is triggered by an app.”</i>
     * 
     * @return property appId
     */
    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“App identifier, if this traffic rule is triggered by an app.”</i>
     * 
     * @param appId
     *            new value of {@code appId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appId} field changed
     */
    public VpnTrafficRule withAppId(String appId) {
        VpnTrafficRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnTrafficRule");
        _x.appId = appId;
        return _x;
    }

    /**
     * <i>“App type, if this traffic rule is triggered by an app.”</i>
     * 
     * @return property appType
     */
    @Property(name="appType")
    @JsonIgnore
    public Optional<VpnTrafficRuleAppType> getAppType() {
        return Optional.ofNullable(appType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“App type, if this traffic rule is triggered by an app.”</i>
     * 
     * @param appType
     *            new value of {@code appType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appType} field changed
     */
    public VpnTrafficRule withAppType(VpnTrafficRuleAppType appType) {
        VpnTrafficRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnTrafficRule");
        _x.appType = appType;
        return _x;
    }

    /**
     * <i>“Claims associated with this traffic rule.”</i>
     * 
     * @return property claims
     */
    @Property(name="claims")
    @JsonIgnore
    public Optional<String> getClaims() {
        return Optional.ofNullable(claims);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code claims} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Claims associated with this traffic rule.”</i>
     * 
     * @param claims
     *            new value of {@code claims} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code claims} field changed
     */
    public VpnTrafficRule withClaims(String claims) {
        VpnTrafficRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnTrafficRule");
        _x.claims = claims;
        return _x;
    }

    /**
     * <i>“Local address range. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property localAddressRanges
     */
    @Property(name="localAddressRanges")
    @JsonIgnore
    public CollectionPage<IPv4Range> getLocalAddressRanges() {
        return new CollectionPage<IPv4Range>(contextPath, IPv4Range.class, this.localAddressRanges, Optional.ofNullable(localAddressRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Local address range. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property localAddressRanges
     */
    @Property(name="localAddressRanges")
    @JsonIgnore
    public CollectionPage<IPv4Range> getLocalAddressRanges(HttpRequestOptions options) {
        return new CollectionPage<IPv4Range>(contextPath, IPv4Range.class, this.localAddressRanges, Optional.ofNullable(localAddressRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Local port range can be set only when protocol is either TCP or UDP (6 or 17).
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property localPortRanges
     */
    @Property(name="localPortRanges")
    @JsonIgnore
    public CollectionPage<NumberRange> getLocalPortRanges() {
        return new CollectionPage<NumberRange>(contextPath, NumberRange.class, this.localPortRanges, Optional.ofNullable(localPortRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Local port range can be set only when protocol is either TCP or UDP (6 or 17).
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property localPortRanges
     */
    @Property(name="localPortRanges")
    @JsonIgnore
    public CollectionPage<NumberRange> getLocalPortRanges(HttpRequestOptions options) {
        return new CollectionPage<NumberRange>(contextPath, NumberRange.class, this.localPortRanges, Optional.ofNullable(localPortRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Name.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public VpnTrafficRule withName(String name) {
        VpnTrafficRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnTrafficRule");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Protocols (0-255). Valid values 0 to 255”</i>
     * 
     * @return property protocols
     */
    @Property(name="protocols")
    @JsonIgnore
    public Optional<Integer> getProtocols() {
        return Optional.ofNullable(protocols);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code protocols} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Protocols (0-255). Valid values 0 to 255”</i>
     * 
     * @param protocols
     *            new value of {@code protocols} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code protocols} field changed
     */
    public VpnTrafficRule withProtocols(Integer protocols) {
        VpnTrafficRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnTrafficRule");
        _x.protocols = protocols;
        return _x;
    }

    /**
     * <i>“Remote address range. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property remoteAddressRanges
     */
    @Property(name="remoteAddressRanges")
    @JsonIgnore
    public CollectionPage<IPv4Range> getRemoteAddressRanges() {
        return new CollectionPage<IPv4Range>(contextPath, IPv4Range.class, this.remoteAddressRanges, Optional.ofNullable(remoteAddressRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Remote address range. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property remoteAddressRanges
     */
    @Property(name="remoteAddressRanges")
    @JsonIgnore
    public CollectionPage<IPv4Range> getRemoteAddressRanges(HttpRequestOptions options) {
        return new CollectionPage<IPv4Range>(contextPath, IPv4Range.class, this.remoteAddressRanges, Optional.ofNullable(remoteAddressRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Remote port range can be set only when protocol is either TCP or UDP (6 or 17).
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property remotePortRanges
     */
    @Property(name="remotePortRanges")
    @JsonIgnore
    public CollectionPage<NumberRange> getRemotePortRanges() {
        return new CollectionPage<NumberRange>(contextPath, NumberRange.class, this.remotePortRanges, Optional.ofNullable(remotePortRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Remote port range can be set only when protocol is either TCP or UDP (6 or 17).
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property remotePortRanges
     */
    @Property(name="remotePortRanges")
    @JsonIgnore
    public CollectionPage<NumberRange> getRemotePortRanges(HttpRequestOptions options) {
        return new CollectionPage<NumberRange>(contextPath, NumberRange.class, this.remotePortRanges, Optional.ofNullable(remotePortRangesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“When app triggered, indicates whether to enable split tunneling along this route
     * .”</i>
     * 
     * @return property routingPolicyType
     */
    @Property(name="routingPolicyType")
    @JsonIgnore
    public Optional<VpnTrafficRuleRoutingPolicyType> getRoutingPolicyType() {
        return Optional.ofNullable(routingPolicyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code routingPolicyType
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When app triggered, indicates whether to enable split tunneling along this route
     * .”</i>
     * 
     * @param routingPolicyType
     *            new value of {@code routingPolicyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code routingPolicyType} field changed
     */
    public VpnTrafficRule withRoutingPolicyType(VpnTrafficRuleRoutingPolicyType routingPolicyType) {
        VpnTrafficRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnTrafficRule");
        _x.routingPolicyType = routingPolicyType;
        return _x;
    }

    public VpnTrafficRule withUnmappedField(String name, Object value) {
        VpnTrafficRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private VpnTrafficRuleAppType appType;
        private String claims;
        private List<IPv4Range> localAddressRanges;
        private String localAddressRangesNextLink;
        private List<NumberRange> localPortRanges;
        private String localPortRangesNextLink;
        private String name;
        private Integer protocols;
        private List<IPv4Range> remoteAddressRanges;
        private String remoteAddressRangesNextLink;
        private List<NumberRange> remotePortRanges;
        private String remotePortRangesNextLink;
        private VpnTrafficRuleRoutingPolicyType routingPolicyType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“App identifier, if this traffic rule is triggered by an app.”</i>
         * 
         * @param appId
         *            value of {@code appId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        /**
         * <i>“App type, if this traffic rule is triggered by an app.”</i>
         * 
         * @param appType
         *            value of {@code appType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appType(VpnTrafficRuleAppType appType) {
            this.appType = appType;
            this.changedFields = changedFields.add("appType");
            return this;
        }

        /**
         * <i>“Claims associated with this traffic rule.”</i>
         * 
         * @param claims
         *            value of {@code claims} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder claims(String claims) {
            this.claims = claims;
            this.changedFields = changedFields.add("claims");
            return this;
        }

        /**
         * <i>“Local address range. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param localAddressRanges
         *            value of {@code localAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localAddressRanges(List<IPv4Range> localAddressRanges) {
            this.localAddressRanges = localAddressRanges;
            this.changedFields = changedFields.add("localAddressRanges");
            return this;
        }

        /**
         * <i>“Local address range. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param localAddressRanges
         *            value of {@code localAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localAddressRanges(IPv4Range... localAddressRanges) {
            return localAddressRanges(Arrays.asList(localAddressRanges));
        }

        /**
         * <i>“Local address range. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param localAddressRangesNextLink
         *            value of {@code localAddressRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localAddressRangesNextLink(String localAddressRangesNextLink) {
            this.localAddressRangesNextLink = localAddressRangesNextLink;
            this.changedFields = changedFields.add("localAddressRanges");
            return this;
        }

        /**
         * <i>“Local port range can be set only when protocol is either TCP or UDP (6 or 17).
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param localPortRanges
         *            value of {@code localPortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localPortRanges(List<NumberRange> localPortRanges) {
            this.localPortRanges = localPortRanges;
            this.changedFields = changedFields.add("localPortRanges");
            return this;
        }

        /**
         * <i>“Local port range can be set only when protocol is either TCP or UDP (6 or 17).
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param localPortRanges
         *            value of {@code localPortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localPortRanges(NumberRange... localPortRanges) {
            return localPortRanges(Arrays.asList(localPortRanges));
        }

        /**
         * <i>“Local port range can be set only when protocol is either TCP or UDP (6 or 17).
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param localPortRangesNextLink
         *            value of {@code localPortRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localPortRangesNextLink(String localPortRangesNextLink) {
            this.localPortRangesNextLink = localPortRangesNextLink;
            this.changedFields = changedFields.add("localPortRanges");
            return this;
        }

        /**
         * <i>“Name.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Protocols (0-255). Valid values 0 to 255”</i>
         * 
         * @param protocols
         *            value of {@code protocols} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder protocols(Integer protocols) {
            this.protocols = protocols;
            this.changedFields = changedFields.add("protocols");
            return this;
        }

        /**
         * <i>“Remote address range. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param remoteAddressRanges
         *            value of {@code remoteAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAddressRanges(List<IPv4Range> remoteAddressRanges) {
            this.remoteAddressRanges = remoteAddressRanges;
            this.changedFields = changedFields.add("remoteAddressRanges");
            return this;
        }

        /**
         * <i>“Remote address range. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param remoteAddressRanges
         *            value of {@code remoteAddressRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAddressRanges(IPv4Range... remoteAddressRanges) {
            return remoteAddressRanges(Arrays.asList(remoteAddressRanges));
        }

        /**
         * <i>“Remote address range. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param remoteAddressRangesNextLink
         *            value of {@code remoteAddressRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAddressRangesNextLink(String remoteAddressRangesNextLink) {
            this.remoteAddressRangesNextLink = remoteAddressRangesNextLink;
            this.changedFields = changedFields.add("remoteAddressRanges");
            return this;
        }

        /**
         * <i>“Remote port range can be set only when protocol is either TCP or UDP (6 or 17).
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param remotePortRanges
         *            value of {@code remotePortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePortRanges(List<NumberRange> remotePortRanges) {
            this.remotePortRanges = remotePortRanges;
            this.changedFields = changedFields.add("remotePortRanges");
            return this;
        }

        /**
         * <i>“Remote port range can be set only when protocol is either TCP or UDP (6 or 17).
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param remotePortRanges
         *            value of {@code remotePortRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePortRanges(NumberRange... remotePortRanges) {
            return remotePortRanges(Arrays.asList(remotePortRanges));
        }

        /**
         * <i>“Remote port range can be set only when protocol is either TCP or UDP (6 or 17).
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param remotePortRangesNextLink
         *            value of {@code remotePortRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remotePortRangesNextLink(String remotePortRangesNextLink) {
            this.remotePortRangesNextLink = remotePortRangesNextLink;
            this.changedFields = changedFields.add("remotePortRanges");
            return this;
        }

        /**
         * <i>“When app triggered, indicates whether to enable split tunneling along this route
         * .”</i>
         * 
         * @param routingPolicyType
         *            value of {@code routingPolicyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routingPolicyType(VpnTrafficRuleRoutingPolicyType routingPolicyType) {
            this.routingPolicyType = routingPolicyType;
            this.changedFields = changedFields.add("routingPolicyType");
            return this;
        }

        public VpnTrafficRule build() {
            VpnTrafficRule _x = new VpnTrafficRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vpnTrafficRule";
            _x.appId = appId;
            _x.appType = appType;
            _x.claims = claims;
            _x.localAddressRanges = localAddressRanges;
            _x.localAddressRangesNextLink = localAddressRangesNextLink;
            _x.localPortRanges = localPortRanges;
            _x.localPortRangesNextLink = localPortRangesNextLink;
            _x.name = name;
            _x.protocols = protocols;
            _x.remoteAddressRanges = remoteAddressRanges;
            _x.remoteAddressRangesNextLink = remoteAddressRangesNextLink;
            _x.remotePortRanges = remotePortRanges;
            _x.remotePortRangesNextLink = remotePortRangesNextLink;
            _x.routingPolicyType = routingPolicyType;
            return _x;
        }
    }

    private VpnTrafficRule _copy() {
        VpnTrafficRule _x = new VpnTrafficRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        _x.appType = appType;
        _x.claims = claims;
        _x.localAddressRanges = localAddressRanges;
        _x.localPortRanges = localPortRanges;
        _x.name = name;
        _x.protocols = protocols;
        _x.remoteAddressRanges = remoteAddressRanges;
        _x.remotePortRanges = remotePortRanges;
        _x.routingPolicyType = routingPolicyType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnTrafficRule[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("appType=");
        b.append(this.appType);
        b.append(", ");
        b.append("claims=");
        b.append(this.claims);
        b.append(", ");
        b.append("localAddressRanges=");
        b.append(this.localAddressRanges);
        b.append(", ");
        b.append("localPortRanges=");
        b.append(this.localPortRanges);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("protocols=");
        b.append(this.protocols);
        b.append(", ");
        b.append("remoteAddressRanges=");
        b.append(this.remoteAddressRanges);
        b.append(", ");
        b.append("remotePortRanges=");
        b.append(this.remotePortRanges);
        b.append(", ");
        b.append("routingPolicyType=");
        b.append(this.routingPolicyType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
