package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“VPN Server definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "description", 
    "isDefaultServer"})
@JsonInclude(Include.NON_NULL)
public class VpnServer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("address")
    protected String address;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isDefaultServer")
    protected Boolean isDefaultServer;

    protected VpnServer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnServer";
    }

    /**
     * <i>“Address (IP address, FQDN or URL)”</i>
     * 
     * @return property address
     */
    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code address} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Address (IP address, FQDN or URL)”</i>
     * 
     * @param address
     *            new value of {@code address} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code address} field changed
     */
    public VpnServer withAddress(String address) {
        VpnServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnServer");
        _x.address = address;
        return _x;
    }

    /**
     * <i>“Description.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public VpnServer withDescription(String description) {
        VpnServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnServer");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Default server.”</i>
     * 
     * @return property isDefaultServer
     */
    @Property(name="isDefaultServer")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultServer() {
        return Optional.ofNullable(isDefaultServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDefaultServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Default server.”</i>
     * 
     * @param isDefaultServer
     *            new value of {@code isDefaultServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDefaultServer} field changed
     */
    public VpnServer withIsDefaultServer(Boolean isDefaultServer) {
        VpnServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnServer");
        _x.isDefaultServer = isDefaultServer;
        return _x;
    }

    public VpnServer withUnmappedField(String name, Object value) {
        VpnServer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String address;
        private String description;
        private Boolean isDefaultServer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Address (IP address, FQDN or URL)”</i>
         * 
         * @param address
         *            value of {@code address} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        /**
         * <i>“Description.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Default server.”</i>
         * 
         * @param isDefaultServer
         *            value of {@code isDefaultServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDefaultServer(Boolean isDefaultServer) {
            this.isDefaultServer = isDefaultServer;
            this.changedFields = changedFields.add("isDefaultServer");
            return this;
        }

        public VpnServer build() {
            VpnServer _x = new VpnServer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vpnServer";
            _x.address = address;
            _x.description = description;
            _x.isDefaultServer = isDefaultServer;
            return _x;
        }
    }

    private VpnServer _copy() {
        VpnServer _x = new VpnServer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.description = description;
        _x.isDefaultServer = isDefaultServer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnServer[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isDefaultServer=");
        b.append(this.isDefaultServer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
