package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.VpnOnDemandRuleConnectionAction;
import odata.msgraph.client.beta.enums.VpnOnDemandRuleConnectionDomainAction;


/**
 * <i>“VPN On-Demand Rule definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "dnsSearchDomains", 
    "domainAction", 
    "domains", 
    "probeRequiredUrl", 
    "probeUrl", 
    "ssids"})
@JsonInclude(Include.NON_NULL)
public class VpnOnDemandRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("action")
    protected VpnOnDemandRuleConnectionAction action;

    @JsonProperty("dnsSearchDomains")
    protected List<String> dnsSearchDomains;

    @JsonProperty("dnsSearchDomains@nextLink")
    protected String dnsSearchDomainsNextLink;

    @JsonProperty("domainAction")
    protected VpnOnDemandRuleConnectionDomainAction domainAction;

    @JsonProperty("domains")
    protected List<String> domains;

    @JsonProperty("domains@nextLink")
    protected String domainsNextLink;

    @JsonProperty("probeRequiredUrl")
    protected String probeRequiredUrl;

    @JsonProperty("probeUrl")
    protected String probeUrl;

    @JsonProperty("ssids")
    protected List<String> ssids;

    @JsonProperty("ssids@nextLink")
    protected String ssidsNextLink;

    protected VpnOnDemandRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnOnDemandRule";
    }

    /**
     * <i>“Action.”</i>
     * 
     * @return property action
     */
    @Property(name="action")
    @JsonIgnore
    public Optional<VpnOnDemandRuleConnectionAction> getAction() {
        return Optional.ofNullable(action);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code action} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Action.”</i>
     * 
     * @param action
     *            new value of {@code action} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code action} field changed
     */
    public VpnOnDemandRule withAction(VpnOnDemandRuleConnectionAction action) {
        VpnOnDemandRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnOnDemandRule");
        _x.action = action;
        return _x;
    }

    /**
     * <i>“DNS Search Domains.”</i>
     * 
     * @return property dnsSearchDomains
     */
    @Property(name="dnsSearchDomains")
    @JsonIgnore
    public CollectionPage<String> getDnsSearchDomains() {
        return new CollectionPage<String>(contextPath, String.class, this.dnsSearchDomains, Optional.ofNullable(dnsSearchDomainsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“DNS Search Domains.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dnsSearchDomains
     */
    @Property(name="dnsSearchDomains")
    @JsonIgnore
    public CollectionPage<String> getDnsSearchDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.dnsSearchDomains, Optional.ofNullable(dnsSearchDomainsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Domain Action (Only applicable when Action is evaluate connection).”</i>
     * 
     * @return property domainAction
     */
    @Property(name="domainAction")
    @JsonIgnore
    public Optional<VpnOnDemandRuleConnectionDomainAction> getDomainAction() {
        return Optional.ofNullable(domainAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code domainAction}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Domain Action (Only applicable when Action is evaluate connection).”</i>
     * 
     * @param domainAction
     *            new value of {@code domainAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code domainAction} field changed
     */
    public VpnOnDemandRule withDomainAction(VpnOnDemandRuleConnectionDomainAction domainAction) {
        VpnOnDemandRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnOnDemandRule");
        _x.domainAction = domainAction;
        return _x;
    }

    /**
     * <i>“Domains (Only applicable when Action is evaluate connection).”</i>
     * 
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains() {
        return new CollectionPage<String>(contextPath, String.class, this.domains, Optional.ofNullable(domainsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Domains (Only applicable when Action is evaluate connection).”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.domains, Optional.ofNullable(domainsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Probe Required Url (Only applicable when Action is evaluate connection and
     * DomainAction is connect if needed).”</i>
     * 
     * @return property probeRequiredUrl
     */
    @Property(name="probeRequiredUrl")
    @JsonIgnore
    public Optional<String> getProbeRequiredUrl() {
        return Optional.ofNullable(probeRequiredUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code probeRequiredUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Probe Required Url (Only applicable when Action is evaluate connection and
     * DomainAction is connect if needed).”</i>
     * 
     * @param probeRequiredUrl
     *            new value of {@code probeRequiredUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code probeRequiredUrl} field changed
     */
    public VpnOnDemandRule withProbeRequiredUrl(String probeRequiredUrl) {
        VpnOnDemandRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnOnDemandRule");
        _x.probeRequiredUrl = probeRequiredUrl;
        return _x;
    }

    /**
     * <i>“A URL to probe. If this URL is successfully fetched (returning a 200 HTTP status
     * code) without redirection, this rule matches.”</i>
     * 
     * @return property probeUrl
     */
    @Property(name="probeUrl")
    @JsonIgnore
    public Optional<String> getProbeUrl() {
        return Optional.ofNullable(probeUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code probeUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A URL to probe. If this URL is successfully fetched (returning a 200 HTTP status
     * code) without redirection, this rule matches.”</i>
     * 
     * @param probeUrl
     *            new value of {@code probeUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code probeUrl} field changed
     */
    public VpnOnDemandRule withProbeUrl(String probeUrl) {
        VpnOnDemandRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnOnDemandRule");
        _x.probeUrl = probeUrl;
        return _x;
    }

    /**
     * <i>“Network Service Set Identifiers (SSIDs).”</i>
     * 
     * @return property ssids
     */
    @Property(name="ssids")
    @JsonIgnore
    public CollectionPage<String> getSsids() {
        return new CollectionPage<String>(contextPath, String.class, this.ssids, Optional.ofNullable(ssidsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Network Service Set Identifiers (SSIDs).”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property ssids
     */
    @Property(name="ssids")
    @JsonIgnore
    public CollectionPage<String> getSsids(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.ssids, Optional.ofNullable(ssidsNextLink), Collections.emptyList(), options);
    }

    public VpnOnDemandRule withUnmappedField(String name, Object value) {
        VpnOnDemandRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private VpnOnDemandRuleConnectionAction action;
        private List<String> dnsSearchDomains;
        private String dnsSearchDomainsNextLink;
        private VpnOnDemandRuleConnectionDomainAction domainAction;
        private List<String> domains;
        private String domainsNextLink;
        private String probeRequiredUrl;
        private String probeUrl;
        private List<String> ssids;
        private String ssidsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Action.”</i>
         * 
         * @param action
         *            value of {@code action} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder action(VpnOnDemandRuleConnectionAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        /**
         * <i>“DNS Search Domains.”</i>
         * 
         * @param dnsSearchDomains
         *            value of {@code dnsSearchDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
            this.dnsSearchDomains = dnsSearchDomains;
            this.changedFields = changedFields.add("dnsSearchDomains");
            return this;
        }

        /**
         * <i>“DNS Search Domains.”</i>
         * 
         * @param dnsSearchDomains
         *            value of {@code dnsSearchDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSearchDomains(String... dnsSearchDomains) {
            return dnsSearchDomains(Arrays.asList(dnsSearchDomains));
        }

        /**
         * <i>“DNS Search Domains.”</i>
         * 
         * @param dnsSearchDomainsNextLink
         *            value of {@code dnsSearchDomains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSearchDomainsNextLink(String dnsSearchDomainsNextLink) {
            this.dnsSearchDomainsNextLink = dnsSearchDomainsNextLink;
            this.changedFields = changedFields.add("dnsSearchDomains");
            return this;
        }

        /**
         * <i>“Domain Action (Only applicable when Action is evaluate connection).”</i>
         * 
         * @param domainAction
         *            value of {@code domainAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainAction(VpnOnDemandRuleConnectionDomainAction domainAction) {
            this.domainAction = domainAction;
            this.changedFields = changedFields.add("domainAction");
            return this;
        }

        /**
         * <i>“Domains (Only applicable when Action is evaluate connection).”</i>
         * 
         * @param domains
         *            value of {@code domains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domains(List<String> domains) {
            this.domains = domains;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        /**
         * <i>“Domains (Only applicable when Action is evaluate connection).”</i>
         * 
         * @param domains
         *            value of {@code domains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domains(String... domains) {
            return domains(Arrays.asList(domains));
        }

        /**
         * <i>“Domains (Only applicable when Action is evaluate connection).”</i>
         * 
         * @param domainsNextLink
         *            value of {@code domains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainsNextLink(String domainsNextLink) {
            this.domainsNextLink = domainsNextLink;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        /**
         * <i>“Probe Required Url (Only applicable when Action is evaluate connection and
         * DomainAction is connect if needed).”</i>
         * 
         * @param probeRequiredUrl
         *            value of {@code probeRequiredUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder probeRequiredUrl(String probeRequiredUrl) {
            this.probeRequiredUrl = probeRequiredUrl;
            this.changedFields = changedFields.add("probeRequiredUrl");
            return this;
        }

        /**
         * <i>“A URL to probe. If this URL is successfully fetched (returning a 200 HTTP status
         * code) without redirection, this rule matches.”</i>
         * 
         * @param probeUrl
         *            value of {@code probeUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder probeUrl(String probeUrl) {
            this.probeUrl = probeUrl;
            this.changedFields = changedFields.add("probeUrl");
            return this;
        }

        /**
         * <i>“Network Service Set Identifiers (SSIDs).”</i>
         * 
         * @param ssids
         *            value of {@code ssids} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ssids(List<String> ssids) {
            this.ssids = ssids;
            this.changedFields = changedFields.add("ssids");
            return this;
        }

        /**
         * <i>“Network Service Set Identifiers (SSIDs).”</i>
         * 
         * @param ssids
         *            value of {@code ssids} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ssids(String... ssids) {
            return ssids(Arrays.asList(ssids));
        }

        /**
         * <i>“Network Service Set Identifiers (SSIDs).”</i>
         * 
         * @param ssidsNextLink
         *            value of {@code ssids@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ssidsNextLink(String ssidsNextLink) {
            this.ssidsNextLink = ssidsNextLink;
            this.changedFields = changedFields.add("ssids");
            return this;
        }

        public VpnOnDemandRule build() {
            VpnOnDemandRule _x = new VpnOnDemandRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vpnOnDemandRule";
            _x.action = action;
            _x.dnsSearchDomains = dnsSearchDomains;
            _x.dnsSearchDomainsNextLink = dnsSearchDomainsNextLink;
            _x.domainAction = domainAction;
            _x.domains = domains;
            _x.domainsNextLink = domainsNextLink;
            _x.probeRequiredUrl = probeRequiredUrl;
            _x.probeUrl = probeUrl;
            _x.ssids = ssids;
            _x.ssidsNextLink = ssidsNextLink;
            return _x;
        }
    }

    private VpnOnDemandRule _copy() {
        VpnOnDemandRule _x = new VpnOnDemandRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.action = action;
        _x.dnsSearchDomains = dnsSearchDomains;
        _x.domainAction = domainAction;
        _x.domains = domains;
        _x.probeRequiredUrl = probeRequiredUrl;
        _x.probeUrl = probeUrl;
        _x.ssids = ssids;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnOnDemandRule[");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("dnsSearchDomains=");
        b.append(this.dnsSearchDomains);
        b.append(", ");
        b.append("domainAction=");
        b.append(this.domainAction);
        b.append(", ");
        b.append("domains=");
        b.append(this.domains);
        b.append(", ");
        b.append("probeRequiredUrl=");
        b.append(this.probeRequiredUrl);
        b.append(", ");
        b.append("probeUrl=");
        b.append(this.probeUrl);
        b.append(", ");
        b.append("ssids=");
        b.append(this.ssids);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
