package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "addedDateTime", 
    "displayName", 
    "verifiedPublisherId"})
@JsonInclude(Include.NON_NULL)
public class VerifiedPublisher implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("addedDateTime")
    protected OffsetDateTime addedDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("verifiedPublisherId")
    protected String verifiedPublisherId;

    protected VerifiedPublisher() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.verifiedPublisher";
    }

    @Property(name="addedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAddedDateTime() {
        return Optional.ofNullable(addedDateTime);
    }

    public VerifiedPublisher withAddedDateTime(OffsetDateTime addedDateTime) {
        VerifiedPublisher _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedPublisher");
        _x.addedDateTime = addedDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public VerifiedPublisher withDisplayName(String displayName) {
        VerifiedPublisher _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedPublisher");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="verifiedPublisherId")
    @JsonIgnore
    public Optional<String> getVerifiedPublisherId() {
        return Optional.ofNullable(verifiedPublisherId);
    }

    public VerifiedPublisher withVerifiedPublisherId(String verifiedPublisherId) {
        VerifiedPublisher _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedPublisher");
        _x.verifiedPublisherId = verifiedPublisherId;
        return _x;
    }

    public VerifiedPublisher withUnmappedField(String name, Object value) {
        VerifiedPublisher _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime addedDateTime;
        private String displayName;
        private String verifiedPublisherId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder addedDateTime(OffsetDateTime addedDateTime) {
            this.addedDateTime = addedDateTime;
            this.changedFields = changedFields.add("addedDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder verifiedPublisherId(String verifiedPublisherId) {
            this.verifiedPublisherId = verifiedPublisherId;
            this.changedFields = changedFields.add("verifiedPublisherId");
            return this;
        }

        public VerifiedPublisher build() {
            VerifiedPublisher _x = new VerifiedPublisher();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.verifiedPublisher";
            _x.addedDateTime = addedDateTime;
            _x.displayName = displayName;
            _x.verifiedPublisherId = verifiedPublisherId;
            return _x;
        }
    }

    private VerifiedPublisher _copy() {
        VerifiedPublisher _x = new VerifiedPublisher();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.addedDateTime = addedDateTime;
        _x.displayName = displayName;
        _x.verifiedPublisherId = verifiedPublisherId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VerifiedPublisher[");
        b.append("addedDateTime=");
        b.append(this.addedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("verifiedPublisherId=");
        b.append(this.verifiedPublisherId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
