package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Evaluates the management condition state as a Boolean expression.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "managementConditionId"})
@JsonInclude(Include.NON_NULL)
public class VariableManagementConditionExpression extends ManagementConditionExpressionModel implements ODataType {

    @JsonProperty("managementConditionId")
    protected String managementConditionId;

    protected VariableManagementConditionExpression() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.variableManagementConditionExpression";
    }

    /**
     * <i>“The management condition id that is used to evaluate the expression.”</i>
     * 
     * @return property managementConditionId
     */
    @Property(name="managementConditionId")
    @JsonIgnore
    public Optional<String> getManagementConditionId() {
        return Optional.ofNullable(managementConditionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managementConditionId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The management condition id that is used to evaluate the expression.”</i>
     * 
     * @param managementConditionId
     *            new value of {@code managementConditionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementConditionId} field changed
     */
    public VariableManagementConditionExpression withManagementConditionId(String managementConditionId) {
        VariableManagementConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.variableManagementConditionExpression");
        _x.managementConditionId = managementConditionId;
        return _x;
    }

    public VariableManagementConditionExpression withUnmappedField(String name, Object value) {
        VariableManagementConditionExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderVariableManagementConditionExpression() {
        return new Builder();
    }

    public static final class Builder {
        private String managementConditionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The management condition id that is used to evaluate the expression.”</i>
         * 
         * @param managementConditionId
         *            value of {@code managementConditionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementConditionId(String managementConditionId) {
            this.managementConditionId = managementConditionId;
            this.changedFields = changedFields.add("managementConditionId");
            return this;
        }

        public VariableManagementConditionExpression build() {
            VariableManagementConditionExpression _x = new VariableManagementConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.variableManagementConditionExpression";
            _x.managementConditionId = managementConditionId;
            return _x;
        }
    }

    private VariableManagementConditionExpression _copy() {
        VariableManagementConditionExpression _x = new VariableManagementConditionExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.managementConditionId = managementConditionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VariableManagementConditionExpression[");
        b.append("managementConditionId=");
        b.append(this.managementConditionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
