package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "message", 
    "ruleName", 
    "validationPassed"})
@JsonInclude(Include.NON_NULL)
public class ValidationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("ruleName")
    protected String ruleName;

    @JsonProperty("validationPassed")
    protected Boolean validationPassed;

    protected ValidationResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.validationResult";
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public ValidationResult withMessage(String message) {
        ValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.validationResult");
        _x.message = message;
        return _x;
    }

    @Property(name="ruleName")
    @JsonIgnore
    public Optional<String> getRuleName() {
        return Optional.ofNullable(ruleName);
    }

    public ValidationResult withRuleName(String ruleName) {
        ValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.validationResult");
        _x.ruleName = ruleName;
        return _x;
    }

    @Property(name="validationPassed")
    @JsonIgnore
    public Optional<Boolean> getValidationPassed() {
        return Optional.ofNullable(validationPassed);
    }

    public ValidationResult withValidationPassed(Boolean validationPassed) {
        ValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.validationResult");
        _x.validationPassed = validationPassed;
        return _x;
    }

    public ValidationResult withUnmappedField(String name, Object value) {
        ValidationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private String ruleName;
        private Boolean validationPassed;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.changedFields = changedFields.add("ruleName");
            return this;
        }

        public Builder validationPassed(Boolean validationPassed) {
            this.validationPassed = validationPassed;
            this.changedFields = changedFields.add("validationPassed");
            return this;
        }

        public ValidationResult build() {
            ValidationResult _x = new ValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.validationResult";
            _x.message = message;
            _x.ruleName = ruleName;
            _x.validationPassed = validationPassed;
            return _x;
        }
    }

    private ValidationResult _copy() {
        ValidationResult _x = new ValidationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.message = message;
        _x.ruleName = ruleName;
        _x.validationPassed = validationPassed;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidationResult[");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("ruleName=");
        b.append(this.ruleName);
        b.append(", ");
        b.append("validationPassed=");
        b.append(this.validationPassed);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
