package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TrainingStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "latestTrainingStatus", 
    "trainingAssignedProperties", 
    "trainingCompletedProperties", 
    "trainingUpdatedProperties"})
@JsonInclude(Include.NON_NULL)
public class UserTrainingEventInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("latestTrainingStatus")
    protected TrainingStatus latestTrainingStatus;

    @JsonProperty("trainingAssignedProperties")
    protected UserTrainingContentEventInfo trainingAssignedProperties;

    @JsonProperty("trainingCompletedProperties")
    protected UserTrainingContentEventInfo trainingCompletedProperties;

    @JsonProperty("trainingUpdatedProperties")
    protected UserTrainingContentEventInfo trainingUpdatedProperties;

    protected UserTrainingEventInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userTrainingEventInfo";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UserTrainingEventInfo withDisplayName(String displayName) {
        UserTrainingEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingEventInfo");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="latestTrainingStatus")
    @JsonIgnore
    public Optional<TrainingStatus> getLatestTrainingStatus() {
        return Optional.ofNullable(latestTrainingStatus);
    }

    public UserTrainingEventInfo withLatestTrainingStatus(TrainingStatus latestTrainingStatus) {
        UserTrainingEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingEventInfo");
        _x.latestTrainingStatus = latestTrainingStatus;
        return _x;
    }

    @Property(name="trainingAssignedProperties")
    @JsonIgnore
    public Optional<UserTrainingContentEventInfo> getTrainingAssignedProperties() {
        return Optional.ofNullable(trainingAssignedProperties);
    }

    public UserTrainingEventInfo withTrainingAssignedProperties(UserTrainingContentEventInfo trainingAssignedProperties) {
        UserTrainingEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingEventInfo");
        _x.trainingAssignedProperties = trainingAssignedProperties;
        return _x;
    }

    @Property(name="trainingCompletedProperties")
    @JsonIgnore
    public Optional<UserTrainingContentEventInfo> getTrainingCompletedProperties() {
        return Optional.ofNullable(trainingCompletedProperties);
    }

    public UserTrainingEventInfo withTrainingCompletedProperties(UserTrainingContentEventInfo trainingCompletedProperties) {
        UserTrainingEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingEventInfo");
        _x.trainingCompletedProperties = trainingCompletedProperties;
        return _x;
    }

    @Property(name="trainingUpdatedProperties")
    @JsonIgnore
    public Optional<UserTrainingContentEventInfo> getTrainingUpdatedProperties() {
        return Optional.ofNullable(trainingUpdatedProperties);
    }

    public UserTrainingEventInfo withTrainingUpdatedProperties(UserTrainingContentEventInfo trainingUpdatedProperties) {
        UserTrainingEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingEventInfo");
        _x.trainingUpdatedProperties = trainingUpdatedProperties;
        return _x;
    }

    public UserTrainingEventInfo withUnmappedField(String name, Object value) {
        UserTrainingEventInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private TrainingStatus latestTrainingStatus;
        private UserTrainingContentEventInfo trainingAssignedProperties;
        private UserTrainingContentEventInfo trainingCompletedProperties;
        private UserTrainingContentEventInfo trainingUpdatedProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder latestTrainingStatus(TrainingStatus latestTrainingStatus) {
            this.latestTrainingStatus = latestTrainingStatus;
            this.changedFields = changedFields.add("latestTrainingStatus");
            return this;
        }

        public Builder trainingAssignedProperties(UserTrainingContentEventInfo trainingAssignedProperties) {
            this.trainingAssignedProperties = trainingAssignedProperties;
            this.changedFields = changedFields.add("trainingAssignedProperties");
            return this;
        }

        public Builder trainingCompletedProperties(UserTrainingContentEventInfo trainingCompletedProperties) {
            this.trainingCompletedProperties = trainingCompletedProperties;
            this.changedFields = changedFields.add("trainingCompletedProperties");
            return this;
        }

        public Builder trainingUpdatedProperties(UserTrainingContentEventInfo trainingUpdatedProperties) {
            this.trainingUpdatedProperties = trainingUpdatedProperties;
            this.changedFields = changedFields.add("trainingUpdatedProperties");
            return this;
        }

        public UserTrainingEventInfo build() {
            UserTrainingEventInfo _x = new UserTrainingEventInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userTrainingEventInfo";
            _x.displayName = displayName;
            _x.latestTrainingStatus = latestTrainingStatus;
            _x.trainingAssignedProperties = trainingAssignedProperties;
            _x.trainingCompletedProperties = trainingCompletedProperties;
            _x.trainingUpdatedProperties = trainingUpdatedProperties;
            return _x;
        }
    }

    private UserTrainingEventInfo _copy() {
        UserTrainingEventInfo _x = new UserTrainingEventInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.latestTrainingStatus = latestTrainingStatus;
        _x.trainingAssignedProperties = trainingAssignedProperties;
        _x.trainingCompletedProperties = trainingCompletedProperties;
        _x.trainingUpdatedProperties = trainingUpdatedProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserTrainingEventInfo[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("latestTrainingStatus=");
        b.append(this.latestTrainingStatus);
        b.append(", ");
        b.append("trainingAssignedProperties=");
        b.append(this.trainingAssignedProperties);
        b.append(", ");
        b.append("trainingCompletedProperties=");
        b.append(this.trainingCompletedProperties);
        b.append(", ");
        b.append("trainingUpdatedProperties=");
        b.append(this.trainingUpdatedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
