package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedTrainingsCount", 
    "completedTrainingsCount", 
    "compromisedDateTime", 
    "inProgressTrainingsCount", 
    "isCompromised", 
    "reportedPhishDateTime", 
    "simulationEvents", 
    "simulationUser", 
    "trainingEvents"})
@JsonInclude(Include.NON_NULL)
public class UserSimulationDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedTrainingsCount")
    protected Integer assignedTrainingsCount;

    @JsonProperty("completedTrainingsCount")
    protected Integer completedTrainingsCount;

    @JsonProperty("compromisedDateTime")
    protected OffsetDateTime compromisedDateTime;

    @JsonProperty("inProgressTrainingsCount")
    protected Integer inProgressTrainingsCount;

    @JsonProperty("isCompromised")
    protected Boolean isCompromised;

    @JsonProperty("reportedPhishDateTime")
    protected OffsetDateTime reportedPhishDateTime;

    @JsonProperty("simulationEvents")
    protected List<UserSimulationEventInfo> simulationEvents;

    @JsonProperty("simulationEvents@nextLink")
    protected String simulationEventsNextLink;

    @JsonProperty("simulationUser")
    protected AttackSimulationUser simulationUser;

    @JsonProperty("trainingEvents")
    protected List<UserTrainingEventInfo> trainingEvents;

    @JsonProperty("trainingEvents@nextLink")
    protected String trainingEventsNextLink;

    protected UserSimulationDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userSimulationDetails";
    }

    @Property(name="assignedTrainingsCount")
    @JsonIgnore
    public Optional<Integer> getAssignedTrainingsCount() {
        return Optional.ofNullable(assignedTrainingsCount);
    }

    public UserSimulationDetails withAssignedTrainingsCount(Integer assignedTrainingsCount) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.assignedTrainingsCount = assignedTrainingsCount;
        return _x;
    }

    @Property(name="completedTrainingsCount")
    @JsonIgnore
    public Optional<Integer> getCompletedTrainingsCount() {
        return Optional.ofNullable(completedTrainingsCount);
    }

    public UserSimulationDetails withCompletedTrainingsCount(Integer completedTrainingsCount) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.completedTrainingsCount = completedTrainingsCount;
        return _x;
    }

    @Property(name="compromisedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompromisedDateTime() {
        return Optional.ofNullable(compromisedDateTime);
    }

    public UserSimulationDetails withCompromisedDateTime(OffsetDateTime compromisedDateTime) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.compromisedDateTime = compromisedDateTime;
        return _x;
    }

    @Property(name="inProgressTrainingsCount")
    @JsonIgnore
    public Optional<Integer> getInProgressTrainingsCount() {
        return Optional.ofNullable(inProgressTrainingsCount);
    }

    public UserSimulationDetails withInProgressTrainingsCount(Integer inProgressTrainingsCount) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.inProgressTrainingsCount = inProgressTrainingsCount;
        return _x;
    }

    @Property(name="isCompromised")
    @JsonIgnore
    public Optional<Boolean> getIsCompromised() {
        return Optional.ofNullable(isCompromised);
    }

    public UserSimulationDetails withIsCompromised(Boolean isCompromised) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.isCompromised = isCompromised;
        return _x;
    }

    @Property(name="reportedPhishDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReportedPhishDateTime() {
        return Optional.ofNullable(reportedPhishDateTime);
    }

    public UserSimulationDetails withReportedPhishDateTime(OffsetDateTime reportedPhishDateTime) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.reportedPhishDateTime = reportedPhishDateTime;
        return _x;
    }

    @Property(name="simulationEvents")
    @JsonIgnore
    public CollectionPage<UserSimulationEventInfo> getSimulationEvents() {
        return new CollectionPage<UserSimulationEventInfo>(contextPath, UserSimulationEventInfo.class, this.simulationEvents, Optional.ofNullable(simulationEventsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="simulationEvents")
    @JsonIgnore
    public CollectionPage<UserSimulationEventInfo> getSimulationEvents(HttpRequestOptions options) {
        return new CollectionPage<UserSimulationEventInfo>(contextPath, UserSimulationEventInfo.class, this.simulationEvents, Optional.ofNullable(simulationEventsNextLink), Collections.emptyList(), options);
    }

    @Property(name="simulationUser")
    @JsonIgnore
    public Optional<AttackSimulationUser> getSimulationUser() {
        return Optional.ofNullable(simulationUser);
    }

    public UserSimulationDetails withSimulationUser(AttackSimulationUser simulationUser) {
        UserSimulationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationDetails");
        _x.simulationUser = simulationUser;
        return _x;
    }

    @Property(name="trainingEvents")
    @JsonIgnore
    public CollectionPage<UserTrainingEventInfo> getTrainingEvents() {
        return new CollectionPage<UserTrainingEventInfo>(contextPath, UserTrainingEventInfo.class, this.trainingEvents, Optional.ofNullable(trainingEventsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="trainingEvents")
    @JsonIgnore
    public CollectionPage<UserTrainingEventInfo> getTrainingEvents(HttpRequestOptions options) {
        return new CollectionPage<UserTrainingEventInfo>(contextPath, UserTrainingEventInfo.class, this.trainingEvents, Optional.ofNullable(trainingEventsNextLink), Collections.emptyList(), options);
    }

    public UserSimulationDetails withUnmappedField(String name, Object value) {
        UserSimulationDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer assignedTrainingsCount;
        private Integer completedTrainingsCount;
        private OffsetDateTime compromisedDateTime;
        private Integer inProgressTrainingsCount;
        private Boolean isCompromised;
        private OffsetDateTime reportedPhishDateTime;
        private List<UserSimulationEventInfo> simulationEvents;
        private String simulationEventsNextLink;
        private AttackSimulationUser simulationUser;
        private List<UserTrainingEventInfo> trainingEvents;
        private String trainingEventsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedTrainingsCount(Integer assignedTrainingsCount) {
            this.assignedTrainingsCount = assignedTrainingsCount;
            this.changedFields = changedFields.add("assignedTrainingsCount");
            return this;
        }

        public Builder completedTrainingsCount(Integer completedTrainingsCount) {
            this.completedTrainingsCount = completedTrainingsCount;
            this.changedFields = changedFields.add("completedTrainingsCount");
            return this;
        }

        public Builder compromisedDateTime(OffsetDateTime compromisedDateTime) {
            this.compromisedDateTime = compromisedDateTime;
            this.changedFields = changedFields.add("compromisedDateTime");
            return this;
        }

        public Builder inProgressTrainingsCount(Integer inProgressTrainingsCount) {
            this.inProgressTrainingsCount = inProgressTrainingsCount;
            this.changedFields = changedFields.add("inProgressTrainingsCount");
            return this;
        }

        public Builder isCompromised(Boolean isCompromised) {
            this.isCompromised = isCompromised;
            this.changedFields = changedFields.add("isCompromised");
            return this;
        }

        public Builder reportedPhishDateTime(OffsetDateTime reportedPhishDateTime) {
            this.reportedPhishDateTime = reportedPhishDateTime;
            this.changedFields = changedFields.add("reportedPhishDateTime");
            return this;
        }

        public Builder simulationEvents(List<UserSimulationEventInfo> simulationEvents) {
            this.simulationEvents = simulationEvents;
            this.changedFields = changedFields.add("simulationEvents");
            return this;
        }

        public Builder simulationEvents(UserSimulationEventInfo... simulationEvents) {
            return simulationEvents(Arrays.asList(simulationEvents));
        }

        public Builder simulationEventsNextLink(String simulationEventsNextLink) {
            this.simulationEventsNextLink = simulationEventsNextLink;
            this.changedFields = changedFields.add("simulationEvents");
            return this;
        }

        public Builder simulationUser(AttackSimulationUser simulationUser) {
            this.simulationUser = simulationUser;
            this.changedFields = changedFields.add("simulationUser");
            return this;
        }

        public Builder trainingEvents(List<UserTrainingEventInfo> trainingEvents) {
            this.trainingEvents = trainingEvents;
            this.changedFields = changedFields.add("trainingEvents");
            return this;
        }

        public Builder trainingEvents(UserTrainingEventInfo... trainingEvents) {
            return trainingEvents(Arrays.asList(trainingEvents));
        }

        public Builder trainingEventsNextLink(String trainingEventsNextLink) {
            this.trainingEventsNextLink = trainingEventsNextLink;
            this.changedFields = changedFields.add("trainingEvents");
            return this;
        }

        public UserSimulationDetails build() {
            UserSimulationDetails _x = new UserSimulationDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userSimulationDetails";
            _x.assignedTrainingsCount = assignedTrainingsCount;
            _x.completedTrainingsCount = completedTrainingsCount;
            _x.compromisedDateTime = compromisedDateTime;
            _x.inProgressTrainingsCount = inProgressTrainingsCount;
            _x.isCompromised = isCompromised;
            _x.reportedPhishDateTime = reportedPhishDateTime;
            _x.simulationEvents = simulationEvents;
            _x.simulationEventsNextLink = simulationEventsNextLink;
            _x.simulationUser = simulationUser;
            _x.trainingEvents = trainingEvents;
            _x.trainingEventsNextLink = trainingEventsNextLink;
            return _x;
        }
    }

    private UserSimulationDetails _copy() {
        UserSimulationDetails _x = new UserSimulationDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedTrainingsCount = assignedTrainingsCount;
        _x.completedTrainingsCount = completedTrainingsCount;
        _x.compromisedDateTime = compromisedDateTime;
        _x.inProgressTrainingsCount = inProgressTrainingsCount;
        _x.isCompromised = isCompromised;
        _x.reportedPhishDateTime = reportedPhishDateTime;
        _x.simulationEvents = simulationEvents;
        _x.simulationUser = simulationUser;
        _x.trainingEvents = trainingEvents;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserSimulationDetails[");
        b.append("assignedTrainingsCount=");
        b.append(this.assignedTrainingsCount);
        b.append(", ");
        b.append("completedTrainingsCount=");
        b.append(this.completedTrainingsCount);
        b.append(", ");
        b.append("compromisedDateTime=");
        b.append(this.compromisedDateTime);
        b.append(", ");
        b.append("inProgressTrainingsCount=");
        b.append(this.inProgressTrainingsCount);
        b.append(", ");
        b.append("isCompromised=");
        b.append(this.isCompromised);
        b.append(", ");
        b.append("reportedPhishDateTime=");
        b.append(this.reportedPhishDateTime);
        b.append(", ");
        b.append("simulationEvents=");
        b.append(this.simulationEvents);
        b.append(", ");
        b.append("simulationUser=");
        b.append(this.simulationUser);
        b.append(", ");
        b.append("trainingEvents=");
        b.append(this.trainingEvents);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
