package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationMethodFeature;

@JsonPropertyOrder({
    "@odata.type", 
    "feature", 
    "userCount"})
@JsonInclude(Include.NON_NULL)
public class UserRegistrationFeatureCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("feature")
    protected AuthenticationMethodFeature feature;

    @JsonProperty("userCount")
    protected Long userCount;

    protected UserRegistrationFeatureCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userRegistrationFeatureCount";
    }

    @Property(name="feature")
    @JsonIgnore
    public Optional<AuthenticationMethodFeature> getFeature() {
        return Optional.ofNullable(feature);
    }

    public UserRegistrationFeatureCount withFeature(AuthenticationMethodFeature feature) {
        UserRegistrationFeatureCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationFeatureCount");
        _x.feature = feature;
        return _x;
    }

    @Property(name="userCount")
    @JsonIgnore
    public Optional<Long> getUserCount() {
        return Optional.ofNullable(userCount);
    }

    public UserRegistrationFeatureCount withUserCount(Long userCount) {
        UserRegistrationFeatureCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationFeatureCount");
        _x.userCount = userCount;
        return _x;
    }

    public UserRegistrationFeatureCount withUnmappedField(String name, Object value) {
        UserRegistrationFeatureCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationMethodFeature feature;
        private Long userCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder feature(AuthenticationMethodFeature feature) {
            this.feature = feature;
            this.changedFields = changedFields.add("feature");
            return this;
        }

        public Builder userCount(Long userCount) {
            this.userCount = userCount;
            this.changedFields = changedFields.add("userCount");
            return this;
        }

        public UserRegistrationFeatureCount build() {
            UserRegistrationFeatureCount _x = new UserRegistrationFeatureCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userRegistrationFeatureCount";
            _x.feature = feature;
            _x.userCount = userCount;
            return _x;
        }
    }

    private UserRegistrationFeatureCount _copy() {
        UserRegistrationFeatureCount _x = new UserRegistrationFeatureCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.feature = feature;
        _x.userCount = userCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserRegistrationFeatureCount[");
        b.append("feature=");
        b.append(this.feature);
        b.append(", ");
        b.append("userCount=");
        b.append(this.userCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
