package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "completedJobCount", 
    "incompleteJobCount", 
    "user", 
    "userDisplayName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class UserPrintUsageSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("completedJobCount")
    protected Integer completedJobCount;

    @JsonProperty("incompleteJobCount")
    protected Integer incompleteJobCount;

    @JsonProperty("user")
    protected Identity user;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected UserPrintUsageSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userPrintUsageSummary";
    }

    @Property(name="completedJobCount")
    @JsonIgnore
    public Optional<Integer> getCompletedJobCount() {
        return Optional.ofNullable(completedJobCount);
    }

    public UserPrintUsageSummary withCompletedJobCount(Integer completedJobCount) {
        UserPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPrintUsageSummary");
        _x.completedJobCount = completedJobCount;
        return _x;
    }

    @Property(name="incompleteJobCount")
    @JsonIgnore
    public Optional<Integer> getIncompleteJobCount() {
        return Optional.ofNullable(incompleteJobCount);
    }

    public UserPrintUsageSummary withIncompleteJobCount(Integer incompleteJobCount) {
        UserPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPrintUsageSummary");
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<Identity> getUser() {
        return Optional.ofNullable(user);
    }

    public UserPrintUsageSummary withUser(Identity user) {
        UserPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPrintUsageSummary");
        _x.user = user;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public UserPrintUsageSummary withUserDisplayName(String userDisplayName) {
        UserPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPrintUsageSummary");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public UserPrintUsageSummary withUserPrincipalName(String userPrincipalName) {
        UserPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPrintUsageSummary");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public UserPrintUsageSummary withUnmappedField(String name, Object value) {
        UserPrintUsageSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer completedJobCount;
        private Integer incompleteJobCount;
        private Identity user;
        private String userDisplayName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder completedJobCount(Integer completedJobCount) {
            this.completedJobCount = completedJobCount;
            this.changedFields = changedFields.add("completedJobCount");
            return this;
        }

        public Builder incompleteJobCount(Integer incompleteJobCount) {
            this.incompleteJobCount = incompleteJobCount;
            this.changedFields = changedFields.add("incompleteJobCount");
            return this;
        }

        public Builder user(Identity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public UserPrintUsageSummary build() {
            UserPrintUsageSummary _x = new UserPrintUsageSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userPrintUsageSummary";
            _x.completedJobCount = completedJobCount;
            _x.incompleteJobCount = incompleteJobCount;
            _x.user = user;
            _x.userDisplayName = userDisplayName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private UserPrintUsageSummary _copy() {
        UserPrintUsageSummary _x = new UserPrintUsageSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.completedJobCount = completedJobCount;
        _x.incompleteJobCount = incompleteJobCount;
        _x.user = user;
        _x.userDisplayName = userDisplayName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserPrintUsageSummary[");
        b.append("completedJobCount=");
        b.append(this.completedJobCount);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
