package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics work from anywhere Windows 10 devices summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "unsupportedOSversionDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsWindows10DevicesSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("unsupportedOSversionDeviceCount")
    protected Integer unsupportedOSversionDeviceCount;

    protected UserExperienceAnalyticsWindows10DevicesSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsWindows10DevicesSummary";
    }

    /**
     * <i>“The count of Windows 10 devices that have unsupported OS versions.”</i>
     * 
     * @return property unsupportedOSversionDeviceCount
     */
    @Property(name="unsupportedOSversionDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnsupportedOSversionDeviceCount() {
        return Optional.ofNullable(unsupportedOSversionDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unsupportedOSversionDeviceCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The count of Windows 10 devices that have unsupported OS versions.”</i>
     * 
     * @param unsupportedOSversionDeviceCount
     *            new value of {@code unsupportedOSversionDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unsupportedOSversionDeviceCount} field changed
     */
    public UserExperienceAnalyticsWindows10DevicesSummary withUnsupportedOSversionDeviceCount(Integer unsupportedOSversionDeviceCount) {
        UserExperienceAnalyticsWindows10DevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWindows10DevicesSummary");
        _x.unsupportedOSversionDeviceCount = unsupportedOSversionDeviceCount;
        return _x;
    }

    public UserExperienceAnalyticsWindows10DevicesSummary withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsWindows10DevicesSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer unsupportedOSversionDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The count of Windows 10 devices that have unsupported OS versions.”</i>
         * 
         * @param unsupportedOSversionDeviceCount
         *            value of {@code unsupportedOSversionDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unsupportedOSversionDeviceCount(Integer unsupportedOSversionDeviceCount) {
            this.unsupportedOSversionDeviceCount = unsupportedOSversionDeviceCount;
            this.changedFields = changedFields.add("unsupportedOSversionDeviceCount");
            return this;
        }

        public UserExperienceAnalyticsWindows10DevicesSummary build() {
            UserExperienceAnalyticsWindows10DevicesSummary _x = new UserExperienceAnalyticsWindows10DevicesSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsWindows10DevicesSummary";
            _x.unsupportedOSversionDeviceCount = unsupportedOSversionDeviceCount;
            return _x;
        }
    }

    private UserExperienceAnalyticsWindows10DevicesSummary _copy() {
        UserExperienceAnalyticsWindows10DevicesSummary _x = new UserExperienceAnalyticsWindows10DevicesSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.unsupportedOSversionDeviceCount = unsupportedOSversionDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsWindows10DevicesSummary[");
        b.append("unsupportedOSversionDeviceCount=");
        b.append(this.unsupportedOSversionDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
