package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience work from anywhere Cloud management devices summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "coManagedDeviceCount", 
    "intuneDeviceCount", 
    "tenantAttachDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsCloudManagementDevicesSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("coManagedDeviceCount")
    protected Integer coManagedDeviceCount;

    @JsonProperty("intuneDeviceCount")
    protected Integer intuneDeviceCount;

    @JsonProperty("tenantAttachDeviceCount")
    protected Integer tenantAttachDeviceCount;

    protected UserExperienceAnalyticsCloudManagementDevicesSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsCloudManagementDevicesSummary";
    }

    /**
     * <i>“Total number of  co-managed devices.”</i>
     * 
     * @return property coManagedDeviceCount
     */
    @Property(name="coManagedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getCoManagedDeviceCount() {
        return Optional.ofNullable(coManagedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * coManagedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total number of  co-managed devices.”</i>
     * 
     * @param coManagedDeviceCount
     *            new value of {@code coManagedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code coManagedDeviceCount} field changed
     */
    public UserExperienceAnalyticsCloudManagementDevicesSummary withCoManagedDeviceCount(Integer coManagedDeviceCount) {
        UserExperienceAnalyticsCloudManagementDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsCloudManagementDevicesSummary");
        _x.coManagedDeviceCount = coManagedDeviceCount;
        return _x;
    }

    /**
     * <i>“The count of intune devices that are not autopilot registerd.”</i>
     * 
     * @return property intuneDeviceCount
     */
    @Property(name="intuneDeviceCount")
    @JsonIgnore
    public Optional<Integer> getIntuneDeviceCount() {
        return Optional.ofNullable(intuneDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intuneDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The count of intune devices that are not autopilot registerd.”</i>
     * 
     * @param intuneDeviceCount
     *            new value of {@code intuneDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneDeviceCount} field changed
     */
    public UserExperienceAnalyticsCloudManagementDevicesSummary withIntuneDeviceCount(Integer intuneDeviceCount) {
        UserExperienceAnalyticsCloudManagementDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsCloudManagementDevicesSummary");
        _x.intuneDeviceCount = intuneDeviceCount;
        return _x;
    }

    /**
     * <i>“Total count of tenant attach devices.”</i>
     * 
     * @return property tenantAttachDeviceCount
     */
    @Property(name="tenantAttachDeviceCount")
    @JsonIgnore
    public Optional<Integer> getTenantAttachDeviceCount() {
        return Optional.ofNullable(tenantAttachDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tenantAttachDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Total count of tenant attach devices.”</i>
     * 
     * @param tenantAttachDeviceCount
     *            new value of {@code tenantAttachDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tenantAttachDeviceCount} field changed
     */
    public UserExperienceAnalyticsCloudManagementDevicesSummary withTenantAttachDeviceCount(Integer tenantAttachDeviceCount) {
        UserExperienceAnalyticsCloudManagementDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsCloudManagementDevicesSummary");
        _x.tenantAttachDeviceCount = tenantAttachDeviceCount;
        return _x;
    }

    public UserExperienceAnalyticsCloudManagementDevicesSummary withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsCloudManagementDevicesSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer coManagedDeviceCount;
        private Integer intuneDeviceCount;
        private Integer tenantAttachDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Total number of  co-managed devices.”</i>
         * 
         * @param coManagedDeviceCount
         *            value of {@code coManagedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder coManagedDeviceCount(Integer coManagedDeviceCount) {
            this.coManagedDeviceCount = coManagedDeviceCount;
            this.changedFields = changedFields.add("coManagedDeviceCount");
            return this;
        }

        /**
         * <i>“The count of intune devices that are not autopilot registerd.”</i>
         * 
         * @param intuneDeviceCount
         *            value of {@code intuneDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneDeviceCount(Integer intuneDeviceCount) {
            this.intuneDeviceCount = intuneDeviceCount;
            this.changedFields = changedFields.add("intuneDeviceCount");
            return this;
        }

        /**
         * <i>“Total count of tenant attach devices.”</i>
         * 
         * @param tenantAttachDeviceCount
         *            value of {@code tenantAttachDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tenantAttachDeviceCount(Integer tenantAttachDeviceCount) {
            this.tenantAttachDeviceCount = tenantAttachDeviceCount;
            this.changedFields = changedFields.add("tenantAttachDeviceCount");
            return this;
        }

        public UserExperienceAnalyticsCloudManagementDevicesSummary build() {
            UserExperienceAnalyticsCloudManagementDevicesSummary _x = new UserExperienceAnalyticsCloudManagementDevicesSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsCloudManagementDevicesSummary";
            _x.coManagedDeviceCount = coManagedDeviceCount;
            _x.intuneDeviceCount = intuneDeviceCount;
            _x.tenantAttachDeviceCount = tenantAttachDeviceCount;
            return _x;
        }
    }

    private UserExperienceAnalyticsCloudManagementDevicesSummary _copy() {
        UserExperienceAnalyticsCloudManagementDevicesSummary _x = new UserExperienceAnalyticsCloudManagementDevicesSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.coManagedDeviceCount = coManagedDeviceCount;
        _x.intuneDeviceCount = intuneDeviceCount;
        _x.tenantAttachDeviceCount = tenantAttachDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsCloudManagementDevicesSummary[");
        b.append("coManagedDeviceCount=");
        b.append(this.coManagedDeviceCount);
        b.append(", ");
        b.append("intuneDeviceCount=");
        b.append(this.intuneDeviceCount);
        b.append(", ");
        b.append("tenantAttachDeviceCount=");
        b.append(this.tenantAttachDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
