package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics work from anywhere cloud identity devices summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceWithoutCloudIdentityCount"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsCloudIdentityDevicesSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceWithoutCloudIdentityCount")
    protected Integer deviceWithoutCloudIdentityCount;

    protected UserExperienceAnalyticsCloudIdentityDevicesSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsCloudIdentityDevicesSummary";
    }

    /**
     * <i>“The count of devices that are not cloud identity.”</i>
     * 
     * @return property deviceWithoutCloudIdentityCount
     */
    @Property(name="deviceWithoutCloudIdentityCount")
    @JsonIgnore
    public Optional<Integer> getDeviceWithoutCloudIdentityCount() {
        return Optional.ofNullable(deviceWithoutCloudIdentityCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceWithoutCloudIdentityCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The count of devices that are not cloud identity.”</i>
     * 
     * @param deviceWithoutCloudIdentityCount
     *            new value of {@code deviceWithoutCloudIdentityCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceWithoutCloudIdentityCount} field changed
     */
    public UserExperienceAnalyticsCloudIdentityDevicesSummary withDeviceWithoutCloudIdentityCount(Integer deviceWithoutCloudIdentityCount) {
        UserExperienceAnalyticsCloudIdentityDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsCloudIdentityDevicesSummary");
        _x.deviceWithoutCloudIdentityCount = deviceWithoutCloudIdentityCount;
        return _x;
    }

    public UserExperienceAnalyticsCloudIdentityDevicesSummary withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsCloudIdentityDevicesSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer deviceWithoutCloudIdentityCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The count of devices that are not cloud identity.”</i>
         * 
         * @param deviceWithoutCloudIdentityCount
         *            value of {@code deviceWithoutCloudIdentityCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceWithoutCloudIdentityCount(Integer deviceWithoutCloudIdentityCount) {
            this.deviceWithoutCloudIdentityCount = deviceWithoutCloudIdentityCount;
            this.changedFields = changedFields.add("deviceWithoutCloudIdentityCount");
            return this;
        }

        public UserExperienceAnalyticsCloudIdentityDevicesSummary build() {
            UserExperienceAnalyticsCloudIdentityDevicesSummary _x = new UserExperienceAnalyticsCloudIdentityDevicesSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsCloudIdentityDevicesSummary";
            _x.deviceWithoutCloudIdentityCount = deviceWithoutCloudIdentityCount;
            return _x;
        }
    }

    private UserExperienceAnalyticsCloudIdentityDevicesSummary _copy() {
        UserExperienceAnalyticsCloudIdentityDevicesSummary _x = new UserExperienceAnalyticsCloudIdentityDevicesSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceWithoutCloudIdentityCount = deviceWithoutCloudIdentityCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsCloudIdentityDevicesSummary[");
        b.append("deviceWithoutCloudIdentityCount=");
        b.append(this.deviceWithoutCloudIdentityCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
