package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AccountStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "lastSeenDateTime", 
    "riskScore", 
    "service", 
    "signinName", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class UserAccount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("signinName")
    protected String signinName;

    @JsonProperty("status")
    protected AccountStatus status;

    protected UserAccount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userAccount";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UserAccount withDisplayName(String displayName) {
        UserAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccount");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public UserAccount withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        UserAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccount");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public UserAccount withRiskScore(String riskScore) {
        UserAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccount");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public UserAccount withService(String service) {
        UserAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccount");
        _x.service = service;
        return _x;
    }

    @Property(name="signinName")
    @JsonIgnore
    public Optional<String> getSigninName() {
        return Optional.ofNullable(signinName);
    }

    public UserAccount withSigninName(String signinName) {
        UserAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccount");
        _x.signinName = signinName;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AccountStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public UserAccount withStatus(AccountStatus status) {
        UserAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccount");
        _x.status = status;
        return _x;
    }

    public UserAccount withUnmappedField(String name, Object value) {
        UserAccount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private OffsetDateTime lastSeenDateTime;
        private String riskScore;
        private String service;
        private String signinName;
        private AccountStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder signinName(String signinName) {
            this.signinName = signinName;
            this.changedFields = changedFields.add("signinName");
            return this;
        }

        public Builder status(AccountStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public UserAccount build() {
            UserAccount _x = new UserAccount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userAccount";
            _x.displayName = displayName;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.riskScore = riskScore;
            _x.service = service;
            _x.signinName = signinName;
            _x.status = status;
            return _x;
        }
    }

    private UserAccount _copy() {
        UserAccount _x = new UserAccount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.riskScore = riskScore;
        _x.service = service;
        _x.signinName = signinName;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserAccount[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("signinName=");
        b.append(this.signinName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
