package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "clickAction", 
    "clickDateTime", 
    "id", 
    "sourceId", 
    "uriDomain", 
    "verdict"})
@JsonInclude(Include.NON_NULL)
public class UriClickSecurityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("clickAction")
    protected String clickAction;

    @JsonProperty("clickDateTime")
    protected OffsetDateTime clickDateTime;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("sourceId")
    protected String sourceId;

    @JsonProperty("uriDomain")
    protected String uriDomain;

    @JsonProperty("verdict")
    protected String verdict;

    protected UriClickSecurityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.uriClickSecurityState";
    }

    @Property(name="clickAction")
    @JsonIgnore
    public Optional<String> getClickAction() {
        return Optional.ofNullable(clickAction);
    }

    public UriClickSecurityState withClickAction(String clickAction) {
        UriClickSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uriClickSecurityState");
        _x.clickAction = clickAction;
        return _x;
    }

    @Property(name="clickDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getClickDateTime() {
        return Optional.ofNullable(clickDateTime);
    }

    public UriClickSecurityState withClickDateTime(OffsetDateTime clickDateTime) {
        UriClickSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uriClickSecurityState");
        _x.clickDateTime = clickDateTime;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public UriClickSecurityState withId(String id) {
        UriClickSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uriClickSecurityState");
        _x.id = id;
        return _x;
    }

    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    public UriClickSecurityState withSourceId(String sourceId) {
        UriClickSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uriClickSecurityState");
        _x.sourceId = sourceId;
        return _x;
    }

    @Property(name="uriDomain")
    @JsonIgnore
    public Optional<String> getUriDomain() {
        return Optional.ofNullable(uriDomain);
    }

    public UriClickSecurityState withUriDomain(String uriDomain) {
        UriClickSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uriClickSecurityState");
        _x.uriDomain = uriDomain;
        return _x;
    }

    @Property(name="verdict")
    @JsonIgnore
    public Optional<String> getVerdict() {
        return Optional.ofNullable(verdict);
    }

    public UriClickSecurityState withVerdict(String verdict) {
        UriClickSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uriClickSecurityState");
        _x.verdict = verdict;
        return _x;
    }

    public UriClickSecurityState withUnmappedField(String name, Object value) {
        UriClickSecurityState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clickAction;
        private OffsetDateTime clickDateTime;
        private String id;
        private String sourceId;
        private String uriDomain;
        private String verdict;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder clickAction(String clickAction) {
            this.clickAction = clickAction;
            this.changedFields = changedFields.add("clickAction");
            return this;
        }

        public Builder clickDateTime(OffsetDateTime clickDateTime) {
            this.clickDateTime = clickDateTime;
            this.changedFields = changedFields.add("clickDateTime");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        public Builder uriDomain(String uriDomain) {
            this.uriDomain = uriDomain;
            this.changedFields = changedFields.add("uriDomain");
            return this;
        }

        public Builder verdict(String verdict) {
            this.verdict = verdict;
            this.changedFields = changedFields.add("verdict");
            return this;
        }

        public UriClickSecurityState build() {
            UriClickSecurityState _x = new UriClickSecurityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.uriClickSecurityState";
            _x.clickAction = clickAction;
            _x.clickDateTime = clickDateTime;
            _x.id = id;
            _x.sourceId = sourceId;
            _x.uriDomain = uriDomain;
            _x.verdict = verdict;
            return _x;
        }
    }

    private UriClickSecurityState _copy() {
        UriClickSecurityState _x = new UriClickSecurityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.clickAction = clickAction;
        _x.clickDateTime = clickDateTime;
        _x.id = id;
        _x.sourceId = sourceId;
        _x.uriDomain = uriDomain;
        _x.verdict = verdict;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UriClickSecurityState[");
        b.append("clickAction=");
        b.append(this.clickAction);
        b.append(", ");
        b.append("clickDateTime=");
        b.append(this.clickDateTime);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("uriDomain=");
        b.append(this.uriDomain);
        b.append(", ");
        b.append("verdict=");
        b.append(this.verdict);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
