package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "calendarSyncEnabled", 
    "deviceAccount", 
    "deviceAccountEmail", 
    "exchangeServer", 
    "passwordRotationEnabled", 
    "sessionInitiationProtocalAddress"})
@JsonInclude(Include.NON_NULL)
public class UpdateWindowsDeviceAccountActionParameter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("calendarSyncEnabled")
    protected Boolean calendarSyncEnabled;

    @JsonProperty("deviceAccount")
    protected WindowsDeviceAccount deviceAccount;

    @JsonProperty("deviceAccountEmail")
    protected String deviceAccountEmail;

    @JsonProperty("exchangeServer")
    protected String exchangeServer;

    @JsonProperty("passwordRotationEnabled")
    protected Boolean passwordRotationEnabled;

    @JsonProperty("sessionInitiationProtocalAddress")
    protected String sessionInitiationProtocalAddress;

    protected UpdateWindowsDeviceAccountActionParameter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.updateWindowsDeviceAccountActionParameter";
    }

    @Property(name="calendarSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getCalendarSyncEnabled() {
        return Optional.ofNullable(calendarSyncEnabled);
    }

    public UpdateWindowsDeviceAccountActionParameter withCalendarSyncEnabled(Boolean calendarSyncEnabled) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindowsDeviceAccountActionParameter");
        _x.calendarSyncEnabled = calendarSyncEnabled;
        return _x;
    }

    @Property(name="deviceAccount")
    @JsonIgnore
    public Optional<WindowsDeviceAccount> getDeviceAccount() {
        return Optional.ofNullable(deviceAccount);
    }

    public UpdateWindowsDeviceAccountActionParameter withDeviceAccount(WindowsDeviceAccount deviceAccount) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindowsDeviceAccountActionParameter");
        _x.deviceAccount = deviceAccount;
        return _x;
    }

    @Property(name="deviceAccountEmail")
    @JsonIgnore
    public Optional<String> getDeviceAccountEmail() {
        return Optional.ofNullable(deviceAccountEmail);
    }

    public UpdateWindowsDeviceAccountActionParameter withDeviceAccountEmail(String deviceAccountEmail) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindowsDeviceAccountActionParameter");
        _x.deviceAccountEmail = deviceAccountEmail;
        return _x;
    }

    @Property(name="exchangeServer")
    @JsonIgnore
    public Optional<String> getExchangeServer() {
        return Optional.ofNullable(exchangeServer);
    }

    public UpdateWindowsDeviceAccountActionParameter withExchangeServer(String exchangeServer) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindowsDeviceAccountActionParameter");
        _x.exchangeServer = exchangeServer;
        return _x;
    }

    @Property(name="passwordRotationEnabled")
    @JsonIgnore
    public Optional<Boolean> getPasswordRotationEnabled() {
        return Optional.ofNullable(passwordRotationEnabled);
    }

    public UpdateWindowsDeviceAccountActionParameter withPasswordRotationEnabled(Boolean passwordRotationEnabled) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindowsDeviceAccountActionParameter");
        _x.passwordRotationEnabled = passwordRotationEnabled;
        return _x;
    }

    @Property(name="sessionInitiationProtocalAddress")
    @JsonIgnore
    public Optional<String> getSessionInitiationProtocalAddress() {
        return Optional.ofNullable(sessionInitiationProtocalAddress);
    }

    public UpdateWindowsDeviceAccountActionParameter withSessionInitiationProtocalAddress(String sessionInitiationProtocalAddress) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindowsDeviceAccountActionParameter");
        _x.sessionInitiationProtocalAddress = sessionInitiationProtocalAddress;
        return _x;
    }

    public UpdateWindowsDeviceAccountActionParameter withUnmappedField(String name, Object value) {
        UpdateWindowsDeviceAccountActionParameter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean calendarSyncEnabled;
        private WindowsDeviceAccount deviceAccount;
        private String deviceAccountEmail;
        private String exchangeServer;
        private Boolean passwordRotationEnabled;
        private String sessionInitiationProtocalAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder calendarSyncEnabled(Boolean calendarSyncEnabled) {
            this.calendarSyncEnabled = calendarSyncEnabled;
            this.changedFields = changedFields.add("calendarSyncEnabled");
            return this;
        }

        public Builder deviceAccount(WindowsDeviceAccount deviceAccount) {
            this.deviceAccount = deviceAccount;
            this.changedFields = changedFields.add("deviceAccount");
            return this;
        }

        public Builder deviceAccountEmail(String deviceAccountEmail) {
            this.deviceAccountEmail = deviceAccountEmail;
            this.changedFields = changedFields.add("deviceAccountEmail");
            return this;
        }

        public Builder exchangeServer(String exchangeServer) {
            this.exchangeServer = exchangeServer;
            this.changedFields = changedFields.add("exchangeServer");
            return this;
        }

        public Builder passwordRotationEnabled(Boolean passwordRotationEnabled) {
            this.passwordRotationEnabled = passwordRotationEnabled;
            this.changedFields = changedFields.add("passwordRotationEnabled");
            return this;
        }

        public Builder sessionInitiationProtocalAddress(String sessionInitiationProtocalAddress) {
            this.sessionInitiationProtocalAddress = sessionInitiationProtocalAddress;
            this.changedFields = changedFields.add("sessionInitiationProtocalAddress");
            return this;
        }

        public UpdateWindowsDeviceAccountActionParameter build() {
            UpdateWindowsDeviceAccountActionParameter _x = new UpdateWindowsDeviceAccountActionParameter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.updateWindowsDeviceAccountActionParameter";
            _x.calendarSyncEnabled = calendarSyncEnabled;
            _x.deviceAccount = deviceAccount;
            _x.deviceAccountEmail = deviceAccountEmail;
            _x.exchangeServer = exchangeServer;
            _x.passwordRotationEnabled = passwordRotationEnabled;
            _x.sessionInitiationProtocalAddress = sessionInitiationProtocalAddress;
            return _x;
        }
    }

    private UpdateWindowsDeviceAccountActionParameter _copy() {
        UpdateWindowsDeviceAccountActionParameter _x = new UpdateWindowsDeviceAccountActionParameter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.calendarSyncEnabled = calendarSyncEnabled;
        _x.deviceAccount = deviceAccount;
        _x.deviceAccountEmail = deviceAccountEmail;
        _x.exchangeServer = exchangeServer;
        _x.passwordRotationEnabled = passwordRotationEnabled;
        _x.sessionInitiationProtocalAddress = sessionInitiationProtocalAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UpdateWindowsDeviceAccountActionParameter[");
        b.append("calendarSyncEnabled=");
        b.append(this.calendarSyncEnabled);
        b.append(", ");
        b.append("deviceAccount=");
        b.append(this.deviceAccount);
        b.append(", ");
        b.append("deviceAccountEmail=");
        b.append(this.deviceAccountEmail);
        b.append(", ");
        b.append("exchangeServer=");
        b.append(this.exchangeServer);
        b.append(", ");
        b.append("passwordRotationEnabled=");
        b.append(this.passwordRotationEnabled);
        b.append(", ");
        b.append("sessionInitiationProtocalAddress=");
        b.append(this.sessionInitiationProtocalAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
