package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Unmanaged device discovered in the network.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceName", 
    "domain", 
    "ipAddress", 
    "lastLoggedOnUser", 
    "lastSeenDateTime", 
    "location", 
    "macAddress", 
    "manufacturer", 
    "model", 
    "os", 
    "osVersion"})
@JsonInclude(Include.NON_NULL)
public class UnmanagedDevice implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("domain")
    protected String domain;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("lastLoggedOnUser")
    protected String lastLoggedOnUser;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("location")
    protected String location;

    @JsonProperty("macAddress")
    protected String macAddress;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("os")
    protected String os;

    @JsonProperty("osVersion")
    protected String osVersion;

    protected UnmanagedDevice() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unmanagedDevice";
    }

    /**
     * <i>“Device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UnmanagedDevice withDeviceName(String deviceName) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Domain.”</i>
     * 
     * @return property domain
     */
    @Property(name="domain")
    @JsonIgnore
    public Optional<String> getDomain() {
        return Optional.ofNullable(domain);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code domain} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Domain.”</i>
     * 
     * @param domain
     *            new value of {@code domain} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code domain} field changed
     */
    public UnmanagedDevice withDomain(String domain) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.domain = domain;
        return _x;
    }

    /**
     * <i>“IP address.”</i>
     * 
     * @return property ipAddress
     */
    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipAddress} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“IP address.”</i>
     * 
     * @param ipAddress
     *            new value of {@code ipAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipAddress} field changed
     */
    public UnmanagedDevice withIpAddress(String ipAddress) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.ipAddress = ipAddress;
        return _x;
    }

    /**
     * <i>“Last logged on user.”</i>
     * 
     * @return property lastLoggedOnUser
     */
    @Property(name="lastLoggedOnUser")
    @JsonIgnore
    public Optional<String> getLastLoggedOnUser() {
        return Optional.ofNullable(lastLoggedOnUser);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastLoggedOnUser}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last logged on user.”</i>
     * 
     * @param lastLoggedOnUser
     *            new value of {@code lastLoggedOnUser} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastLoggedOnUser} field changed
     */
    public UnmanagedDevice withLastLoggedOnUser(String lastLoggedOnUser) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.lastLoggedOnUser = lastLoggedOnUser;
        return _x;
    }

    /**
     * <i>“Last seen date and time.”</i>
     * 
     * @return property lastSeenDateTime
     */
    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSeenDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last seen date and time.”</i>
     * 
     * @param lastSeenDateTime
     *            new value of {@code lastSeenDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSeenDateTime} field changed
     */
    public UnmanagedDevice withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    /**
     * <i>“Location.”</i>
     * 
     * @return property location
     */
    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code location} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Location.”</i>
     * 
     * @param location
     *            new value of {@code location} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code location} field changed
     */
    public UnmanagedDevice withLocation(String location) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.location = location;
        return _x;
    }

    /**
     * <i>“MAC address.”</i>
     * 
     * @return property macAddress
     */
    @Property(name="macAddress")
    @JsonIgnore
    public Optional<String> getMacAddress() {
        return Optional.ofNullable(macAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macAddress} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“MAC address.”</i>
     * 
     * @param macAddress
     *            new value of {@code macAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macAddress} field changed
     */
    public UnmanagedDevice withMacAddress(String macAddress) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.macAddress = macAddress;
        return _x;
    }

    /**
     * <i>“Manufacturer.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Manufacturer.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UnmanagedDevice withManufacturer(String manufacturer) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“Model.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Model.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UnmanagedDevice withModel(String model) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“Operating system.”</i>
     * 
     * @return property os
     */
    @Property(name="os")
    @JsonIgnore
    public Optional<String> getOs() {
        return Optional.ofNullable(os);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code os} field changed
     * . Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operating system.”</i>
     * 
     * @param os
     *            new value of {@code os} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code os} field changed
     */
    public UnmanagedDevice withOs(String os) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.os = os;
        return _x;
    }

    /**
     * <i>“Operating system version.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operating system version.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public UnmanagedDevice withOsVersion(String osVersion) {
        UnmanagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unmanagedDevice");
        _x.osVersion = osVersion;
        return _x;
    }

    public UnmanagedDevice withUnmappedField(String name, Object value) {
        UnmanagedDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceName;
        private String domain;
        private String ipAddress;
        private String lastLoggedOnUser;
        private OffsetDateTime lastSeenDateTime;
        private String location;
        private String macAddress;
        private String manufacturer;
        private String model;
        private String os;
        private String osVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Domain.”</i>
         * 
         * @param domain
         *            value of {@code domain} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domain(String domain) {
            this.domain = domain;
            this.changedFields = changedFields.add("domain");
            return this;
        }

        /**
         * <i>“IP address.”</i>
         * 
         * @param ipAddress
         *            value of {@code ipAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        /**
         * <i>“Last logged on user.”</i>
         * 
         * @param lastLoggedOnUser
         *            value of {@code lastLoggedOnUser} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastLoggedOnUser(String lastLoggedOnUser) {
            this.lastLoggedOnUser = lastLoggedOnUser;
            this.changedFields = changedFields.add("lastLoggedOnUser");
            return this;
        }

        /**
         * <i>“Last seen date and time.”</i>
         * 
         * @param lastSeenDateTime
         *            value of {@code lastSeenDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        /**
         * <i>“Location.”</i>
         * 
         * @param location
         *            value of {@code location} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        /**
         * <i>“MAC address.”</i>
         * 
         * @param macAddress
         *            value of {@code macAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.changedFields = changedFields.add("macAddress");
            return this;
        }

        /**
         * <i>“Manufacturer.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“Model.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“Operating system.”</i>
         * 
         * @param os
         *            value of {@code os} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder os(String os) {
            this.os = os;
            this.changedFields = changedFields.add("os");
            return this;
        }

        /**
         * <i>“Operating system version.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public UnmanagedDevice build() {
            UnmanagedDevice _x = new UnmanagedDevice();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unmanagedDevice";
            _x.deviceName = deviceName;
            _x.domain = domain;
            _x.ipAddress = ipAddress;
            _x.lastLoggedOnUser = lastLoggedOnUser;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.location = location;
            _x.macAddress = macAddress;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.os = os;
            _x.osVersion = osVersion;
            return _x;
        }
    }

    private UnmanagedDevice _copy() {
        UnmanagedDevice _x = new UnmanagedDevice();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceName = deviceName;
        _x.domain = domain;
        _x.ipAddress = ipAddress;
        _x.lastLoggedOnUser = lastLoggedOnUser;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.location = location;
        _x.macAddress = macAddress;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.os = os;
        _x.osVersion = osVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnmanagedDevice[");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("domain=");
        b.append(this.domain);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("lastLoggedOnUser=");
        b.append(this.lastLoggedOnUser);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("macAddress=");
        b.append(this.macAddress);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("os=");
        b.append(this.os);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
