package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "caller", 
    "enforcedSettings", 
    "inheritableSettings", 
    "level", 
    "operations"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleManagementPolicyRuleTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("caller")
    protected String caller;

    @JsonProperty("enforcedSettings")
    protected List<String> enforcedSettings;

    @JsonProperty("enforcedSettings@nextLink")
    protected String enforcedSettingsNextLink;

    @JsonProperty("inheritableSettings")
    protected List<String> inheritableSettings;

    @JsonProperty("inheritableSettings@nextLink")
    protected String inheritableSettingsNextLink;

    @JsonProperty("level")
    protected String level;

    @JsonProperty("operations")
    protected List<String> operations;

    @JsonProperty("operations@nextLink")
    protected String operationsNextLink;

    protected UnifiedRoleManagementPolicyRuleTarget() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleManagementPolicyRuleTarget";
    }

    @Property(name="caller")
    @JsonIgnore
    public Optional<String> getCaller() {
        return Optional.ofNullable(caller);
    }

    public UnifiedRoleManagementPolicyRuleTarget withCaller(String caller) {
        UnifiedRoleManagementPolicyRuleTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyRuleTarget");
        _x.caller = caller;
        return _x;
    }

    @Property(name="enforcedSettings")
    @JsonIgnore
    public CollectionPage<String> getEnforcedSettings() {
        return new CollectionPage<String>(contextPath, String.class, this.enforcedSettings, Optional.ofNullable(enforcedSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enforcedSettings")
    @JsonIgnore
    public CollectionPage<String> getEnforcedSettings(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enforcedSettings, Optional.ofNullable(enforcedSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="inheritableSettings")
    @JsonIgnore
    public CollectionPage<String> getInheritableSettings() {
        return new CollectionPage<String>(contextPath, String.class, this.inheritableSettings, Optional.ofNullable(inheritableSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="inheritableSettings")
    @JsonIgnore
    public CollectionPage<String> getInheritableSettings(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.inheritableSettings, Optional.ofNullable(inheritableSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="level")
    @JsonIgnore
    public Optional<String> getLevel() {
        return Optional.ofNullable(level);
    }

    public UnifiedRoleManagementPolicyRuleTarget withLevel(String level) {
        UnifiedRoleManagementPolicyRuleTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyRuleTarget");
        _x.level = level;
        return _x;
    }

    @Property(name="operations")
    @JsonIgnore
    public CollectionPage<String> getOperations() {
        return new CollectionPage<String>(contextPath, String.class, this.operations, Optional.ofNullable(operationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="operations")
    @JsonIgnore
    public CollectionPage<String> getOperations(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.operations, Optional.ofNullable(operationsNextLink), Collections.emptyList(), options);
    }

    public UnifiedRoleManagementPolicyRuleTarget withUnmappedField(String name, Object value) {
        UnifiedRoleManagementPolicyRuleTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String caller;
        private List<String> enforcedSettings;
        private String enforcedSettingsNextLink;
        private List<String> inheritableSettings;
        private String inheritableSettingsNextLink;
        private String level;
        private List<String> operations;
        private String operationsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder caller(String caller) {
            this.caller = caller;
            this.changedFields = changedFields.add("caller");
            return this;
        }

        public Builder enforcedSettings(List<String> enforcedSettings) {
            this.enforcedSettings = enforcedSettings;
            this.changedFields = changedFields.add("enforcedSettings");
            return this;
        }

        public Builder enforcedSettings(String... enforcedSettings) {
            return enforcedSettings(Arrays.asList(enforcedSettings));
        }

        public Builder enforcedSettingsNextLink(String enforcedSettingsNextLink) {
            this.enforcedSettingsNextLink = enforcedSettingsNextLink;
            this.changedFields = changedFields.add("enforcedSettings");
            return this;
        }

        public Builder inheritableSettings(List<String> inheritableSettings) {
            this.inheritableSettings = inheritableSettings;
            this.changedFields = changedFields.add("inheritableSettings");
            return this;
        }

        public Builder inheritableSettings(String... inheritableSettings) {
            return inheritableSettings(Arrays.asList(inheritableSettings));
        }

        public Builder inheritableSettingsNextLink(String inheritableSettingsNextLink) {
            this.inheritableSettingsNextLink = inheritableSettingsNextLink;
            this.changedFields = changedFields.add("inheritableSettings");
            return this;
        }

        public Builder level(String level) {
            this.level = level;
            this.changedFields = changedFields.add("level");
            return this;
        }

        public Builder operations(List<String> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(String... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder operationsNextLink(String operationsNextLink) {
            this.operationsNextLink = operationsNextLink;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public UnifiedRoleManagementPolicyRuleTarget build() {
            UnifiedRoleManagementPolicyRuleTarget _x = new UnifiedRoleManagementPolicyRuleTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleManagementPolicyRuleTarget";
            _x.caller = caller;
            _x.enforcedSettings = enforcedSettings;
            _x.enforcedSettingsNextLink = enforcedSettingsNextLink;
            _x.inheritableSettings = inheritableSettings;
            _x.inheritableSettingsNextLink = inheritableSettingsNextLink;
            _x.level = level;
            _x.operations = operations;
            _x.operationsNextLink = operationsNextLink;
            return _x;
        }
    }

    private UnifiedRoleManagementPolicyRuleTarget _copy() {
        UnifiedRoleManagementPolicyRuleTarget _x = new UnifiedRoleManagementPolicyRuleTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.caller = caller;
        _x.enforcedSettings = enforcedSettings;
        _x.inheritableSettings = inheritableSettings;
        _x.level = level;
        _x.operations = operations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleManagementPolicyRuleTarget[");
        b.append("caller=");
        b.append(this.caller);
        b.append(", ");
        b.append("enforcedSettings=");
        b.append(this.enforcedSettings);
        b.append(", ");
        b.append("inheritableSettings=");
        b.append(this.inheritableSettings);
        b.append(", ");
        b.append("level=");
        b.append(this.level);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
