package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "d", 
    "dp", 
    "dq", 
    "e", 
    "exp", 
    "k", 
    "kid", 
    "kty", 
    "n", 
    "nbf", 
    "p", 
    "q", 
    "qi", 
    "use", 
    "x5c", 
    "x5t"})
@JsonInclude(Include.NON_NULL)
public class TrustFrameworkKey implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("d")
    protected String d;

    @JsonProperty("dp")
    protected String dp;

    @JsonProperty("dq")
    protected String dq;

    @JsonProperty("e")
    protected String e;

    @JsonProperty("exp")
    protected Long exp;

    @JsonProperty("k")
    protected String k;

    @JsonProperty("kid")
    protected String kid;

    @JsonProperty("kty")
    protected String kty;

    @JsonProperty("n")
    protected String n;

    @JsonProperty("nbf")
    protected Long nbf;

    @JsonProperty("p")
    protected String p;

    @JsonProperty("q")
    protected String q;

    @JsonProperty("qi")
    protected String qi;

    @JsonProperty("use")
    protected String use;

    @JsonProperty("x5c")
    protected List<String> x5c;

    @JsonProperty("x5c@nextLink")
    protected String x5cNextLink;

    @JsonProperty("x5t")
    protected String x5t;

    protected TrustFrameworkKey() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.trustFrameworkKey";
    }

    @Property(name="d")
    @JsonIgnore
    public Optional<String> getD() {
        return Optional.ofNullable(d);
    }

    public TrustFrameworkKey withD(String d) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.d = d;
        return _x;
    }

    @Property(name="dp")
    @JsonIgnore
    public Optional<String> getDp() {
        return Optional.ofNullable(dp);
    }

    public TrustFrameworkKey withDp(String dp) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.dp = dp;
        return _x;
    }

    @Property(name="dq")
    @JsonIgnore
    public Optional<String> getDq() {
        return Optional.ofNullable(dq);
    }

    public TrustFrameworkKey withDq(String dq) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.dq = dq;
        return _x;
    }

    @Property(name="e")
    @JsonIgnore
    public Optional<String> getE() {
        return Optional.ofNullable(e);
    }

    public TrustFrameworkKey withE(String e) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.e = e;
        return _x;
    }

    @Property(name="exp")
    @JsonIgnore
    public Optional<Long> getExp() {
        return Optional.ofNullable(exp);
    }

    public TrustFrameworkKey withExp(Long exp) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.exp = exp;
        return _x;
    }

    @Property(name="k")
    @JsonIgnore
    public Optional<String> getK() {
        return Optional.ofNullable(k);
    }

    public TrustFrameworkKey withK(String k) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.k = k;
        return _x;
    }

    @Property(name="kid")
    @JsonIgnore
    public Optional<String> getKid() {
        return Optional.ofNullable(kid);
    }

    public TrustFrameworkKey withKid(String kid) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.kid = kid;
        return _x;
    }

    @Property(name="kty")
    @JsonIgnore
    public Optional<String> getKty() {
        return Optional.ofNullable(kty);
    }

    public TrustFrameworkKey withKty(String kty) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.kty = kty;
        return _x;
    }

    @Property(name="n")
    @JsonIgnore
    public Optional<String> getN() {
        return Optional.ofNullable(n);
    }

    public TrustFrameworkKey withN(String n) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.n = n;
        return _x;
    }

    @Property(name="nbf")
    @JsonIgnore
    public Optional<Long> getNbf() {
        return Optional.ofNullable(nbf);
    }

    public TrustFrameworkKey withNbf(Long nbf) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.nbf = nbf;
        return _x;
    }

    @Property(name="p")
    @JsonIgnore
    public Optional<String> getP() {
        return Optional.ofNullable(p);
    }

    public TrustFrameworkKey withP(String p) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.p = p;
        return _x;
    }

    @Property(name="q")
    @JsonIgnore
    public Optional<String> getQ() {
        return Optional.ofNullable(q);
    }

    public TrustFrameworkKey withQ(String q) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.q = q;
        return _x;
    }

    @Property(name="qi")
    @JsonIgnore
    public Optional<String> getQi() {
        return Optional.ofNullable(qi);
    }

    public TrustFrameworkKey withQi(String qi) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.qi = qi;
        return _x;
    }

    @Property(name="use")
    @JsonIgnore
    public Optional<String> getUse() {
        return Optional.ofNullable(use);
    }

    public TrustFrameworkKey withUse(String use) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.use = use;
        return _x;
    }

    @Property(name="x5c")
    @JsonIgnore
    public CollectionPage<String> getX5c() {
        return new CollectionPage<String>(contextPath, String.class, this.x5c, Optional.ofNullable(x5cNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="x5c")
    @JsonIgnore
    public CollectionPage<String> getX5c(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.x5c, Optional.ofNullable(x5cNextLink), Collections.emptyList(), options);
    }

    @Property(name="x5t")
    @JsonIgnore
    public Optional<String> getX5t() {
        return Optional.ofNullable(x5t);
    }

    public TrustFrameworkKey withX5t(String x5t) {
        TrustFrameworkKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trustFrameworkKey");
        _x.x5t = x5t;
        return _x;
    }

    public TrustFrameworkKey withUnmappedField(String name, Object value) {
        TrustFrameworkKey _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String d;
        private String dp;
        private String dq;
        private String e;
        private Long exp;
        private String k;
        private String kid;
        private String kty;
        private String n;
        private Long nbf;
        private String p;
        private String q;
        private String qi;
        private String use;
        private List<String> x5c;
        private String x5cNextLink;
        private String x5t;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder d(String d) {
            this.d = d;
            this.changedFields = changedFields.add("d");
            return this;
        }

        public Builder dp(String dp) {
            this.dp = dp;
            this.changedFields = changedFields.add("dp");
            return this;
        }

        public Builder dq(String dq) {
            this.dq = dq;
            this.changedFields = changedFields.add("dq");
            return this;
        }

        public Builder e(String e) {
            this.e = e;
            this.changedFields = changedFields.add("e");
            return this;
        }

        public Builder exp(Long exp) {
            this.exp = exp;
            this.changedFields = changedFields.add("exp");
            return this;
        }

        public Builder k(String k) {
            this.k = k;
            this.changedFields = changedFields.add("k");
            return this;
        }

        public Builder kid(String kid) {
            this.kid = kid;
            this.changedFields = changedFields.add("kid");
            return this;
        }

        public Builder kty(String kty) {
            this.kty = kty;
            this.changedFields = changedFields.add("kty");
            return this;
        }

        public Builder n(String n) {
            this.n = n;
            this.changedFields = changedFields.add("n");
            return this;
        }

        public Builder nbf(Long nbf) {
            this.nbf = nbf;
            this.changedFields = changedFields.add("nbf");
            return this;
        }

        public Builder p(String p) {
            this.p = p;
            this.changedFields = changedFields.add("p");
            return this;
        }

        public Builder q(String q) {
            this.q = q;
            this.changedFields = changedFields.add("q");
            return this;
        }

        public Builder qi(String qi) {
            this.qi = qi;
            this.changedFields = changedFields.add("qi");
            return this;
        }

        public Builder use(String use) {
            this.use = use;
            this.changedFields = changedFields.add("use");
            return this;
        }

        public Builder x5c(List<String> x5c) {
            this.x5c = x5c;
            this.changedFields = changedFields.add("x5c");
            return this;
        }

        public Builder x5c(String... x5c) {
            return x5c(Arrays.asList(x5c));
        }

        public Builder x5cNextLink(String x5cNextLink) {
            this.x5cNextLink = x5cNextLink;
            this.changedFields = changedFields.add("x5c");
            return this;
        }

        public Builder x5t(String x5t) {
            this.x5t = x5t;
            this.changedFields = changedFields.add("x5t");
            return this;
        }

        public TrustFrameworkKey build() {
            TrustFrameworkKey _x = new TrustFrameworkKey();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.trustFrameworkKey";
            _x.d = d;
            _x.dp = dp;
            _x.dq = dq;
            _x.e = e;
            _x.exp = exp;
            _x.k = k;
            _x.kid = kid;
            _x.kty = kty;
            _x.n = n;
            _x.nbf = nbf;
            _x.p = p;
            _x.q = q;
            _x.qi = qi;
            _x.use = use;
            _x.x5c = x5c;
            _x.x5cNextLink = x5cNextLink;
            _x.x5t = x5t;
            return _x;
        }
    }

    private TrustFrameworkKey _copy() {
        TrustFrameworkKey _x = new TrustFrameworkKey();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.d = d;
        _x.dp = dp;
        _x.dq = dq;
        _x.e = e;
        _x.exp = exp;
        _x.k = k;
        _x.kid = kid;
        _x.kty = kty;
        _x.n = n;
        _x.nbf = nbf;
        _x.p = p;
        _x.q = q;
        _x.qi = qi;
        _x.use = use;
        _x.x5c = x5c;
        _x.x5t = x5t;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TrustFrameworkKey[");
        b.append("d=");
        b.append(this.d);
        b.append(", ");
        b.append("dp=");
        b.append(this.dp);
        b.append(", ");
        b.append("dq=");
        b.append(this.dq);
        b.append(", ");
        b.append("e=");
        b.append(this.e);
        b.append(", ");
        b.append("exp=");
        b.append(this.exp);
        b.append(", ");
        b.append("k=");
        b.append(this.k);
        b.append(", ");
        b.append("kid=");
        b.append(this.kid);
        b.append(", ");
        b.append("kty=");
        b.append(this.kty);
        b.append(", ");
        b.append("n=");
        b.append(this.n);
        b.append(", ");
        b.append("nbf=");
        b.append(this.nbf);
        b.append(", ");
        b.append("p=");
        b.append(this.p);
        b.append(", ");
        b.append("q=");
        b.append(this.q);
        b.append(", ");
        b.append("qi=");
        b.append(this.qi);
        b.append(", ");
        b.append("use=");
        b.append(this.use);
        b.append(", ");
        b.append("x5c=");
        b.append(this.x5c);
        b.append(", ");
        b.append("x5t=");
        b.append(this.x5t);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
