package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TranslationBehavior;

@JsonPropertyOrder({
    "@odata.type", 
    "languageOverrides", 
    "translationBehavior", 
    "untranslatedLanguages"})
@JsonInclude(Include.NON_NULL)
public class TranslationPreferences implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("languageOverrides")
    protected List<TranslationLanguageOverride> languageOverrides;

    @JsonProperty("languageOverrides@nextLink")
    protected String languageOverridesNextLink;

    @JsonProperty("translationBehavior")
    protected TranslationBehavior translationBehavior;

    @JsonProperty("untranslatedLanguages")
    protected List<String> untranslatedLanguages;

    @JsonProperty("untranslatedLanguages@nextLink")
    protected String untranslatedLanguagesNextLink;

    protected TranslationPreferences() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.translationPreferences";
    }

    @Property(name="languageOverrides")
    @JsonIgnore
    public CollectionPage<TranslationLanguageOverride> getLanguageOverrides() {
        return new CollectionPage<TranslationLanguageOverride>(contextPath, TranslationLanguageOverride.class, this.languageOverrides, Optional.ofNullable(languageOverridesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="languageOverrides")
    @JsonIgnore
    public CollectionPage<TranslationLanguageOverride> getLanguageOverrides(HttpRequestOptions options) {
        return new CollectionPage<TranslationLanguageOverride>(contextPath, TranslationLanguageOverride.class, this.languageOverrides, Optional.ofNullable(languageOverridesNextLink), Collections.emptyList(), options);
    }

    @Property(name="translationBehavior")
    @JsonIgnore
    public Optional<TranslationBehavior> getTranslationBehavior() {
        return Optional.ofNullable(translationBehavior);
    }

    public TranslationPreferences withTranslationBehavior(TranslationBehavior translationBehavior) {
        TranslationPreferences _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.translationPreferences");
        _x.translationBehavior = translationBehavior;
        return _x;
    }

    @Property(name="untranslatedLanguages")
    @JsonIgnore
    public CollectionPage<String> getUntranslatedLanguages() {
        return new CollectionPage<String>(contextPath, String.class, this.untranslatedLanguages, Optional.ofNullable(untranslatedLanguagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="untranslatedLanguages")
    @JsonIgnore
    public CollectionPage<String> getUntranslatedLanguages(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.untranslatedLanguages, Optional.ofNullable(untranslatedLanguagesNextLink), Collections.emptyList(), options);
    }

    public TranslationPreferences withUnmappedField(String name, Object value) {
        TranslationPreferences _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<TranslationLanguageOverride> languageOverrides;
        private String languageOverridesNextLink;
        private TranslationBehavior translationBehavior;
        private List<String> untranslatedLanguages;
        private String untranslatedLanguagesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder languageOverrides(List<TranslationLanguageOverride> languageOverrides) {
            this.languageOverrides = languageOverrides;
            this.changedFields = changedFields.add("languageOverrides");
            return this;
        }

        public Builder languageOverrides(TranslationLanguageOverride... languageOverrides) {
            return languageOverrides(Arrays.asList(languageOverrides));
        }

        public Builder languageOverridesNextLink(String languageOverridesNextLink) {
            this.languageOverridesNextLink = languageOverridesNextLink;
            this.changedFields = changedFields.add("languageOverrides");
            return this;
        }

        public Builder translationBehavior(TranslationBehavior translationBehavior) {
            this.translationBehavior = translationBehavior;
            this.changedFields = changedFields.add("translationBehavior");
            return this;
        }

        public Builder untranslatedLanguages(List<String> untranslatedLanguages) {
            this.untranslatedLanguages = untranslatedLanguages;
            this.changedFields = changedFields.add("untranslatedLanguages");
            return this;
        }

        public Builder untranslatedLanguages(String... untranslatedLanguages) {
            return untranslatedLanguages(Arrays.asList(untranslatedLanguages));
        }

        public Builder untranslatedLanguagesNextLink(String untranslatedLanguagesNextLink) {
            this.untranslatedLanguagesNextLink = untranslatedLanguagesNextLink;
            this.changedFields = changedFields.add("untranslatedLanguages");
            return this;
        }

        public TranslationPreferences build() {
            TranslationPreferences _x = new TranslationPreferences();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.translationPreferences";
            _x.languageOverrides = languageOverrides;
            _x.languageOverridesNextLink = languageOverridesNextLink;
            _x.translationBehavior = translationBehavior;
            _x.untranslatedLanguages = untranslatedLanguages;
            _x.untranslatedLanguagesNextLink = untranslatedLanguagesNextLink;
            return _x;
        }
    }

    private TranslationPreferences _copy() {
        TranslationPreferences _x = new TranslationPreferences();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.languageOverrides = languageOverrides;
        _x.translationBehavior = translationBehavior;
        _x.untranslatedLanguages = untranslatedLanguages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TranslationPreferences[");
        b.append("languageOverrides=");
        b.append(this.languageOverrides);
        b.append(", ");
        b.append("translationBehavior=");
        b.append(this.translationBehavior);
        b.append(", ");
        b.append("untranslatedLanguages=");
        b.append(this.untranslatedLanguages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
