package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedTrainingsInfos", 
    "trainingsAssignedUserCount"})
@JsonInclude(Include.NON_NULL)
public class TrainingEventsContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedTrainingsInfos")
    protected List<AssignedTrainingInfo> assignedTrainingsInfos;

    @JsonProperty("assignedTrainingsInfos@nextLink")
    protected String assignedTrainingsInfosNextLink;

    @JsonProperty("trainingsAssignedUserCount")
    protected Integer trainingsAssignedUserCount;

    protected TrainingEventsContent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.trainingEventsContent";
    }

    @Property(name="assignedTrainingsInfos")
    @JsonIgnore
    public CollectionPage<AssignedTrainingInfo> getAssignedTrainingsInfos() {
        return new CollectionPage<AssignedTrainingInfo>(contextPath, AssignedTrainingInfo.class, this.assignedTrainingsInfos, Optional.ofNullable(assignedTrainingsInfosNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedTrainingsInfos")
    @JsonIgnore
    public CollectionPage<AssignedTrainingInfo> getAssignedTrainingsInfos(HttpRequestOptions options) {
        return new CollectionPage<AssignedTrainingInfo>(contextPath, AssignedTrainingInfo.class, this.assignedTrainingsInfos, Optional.ofNullable(assignedTrainingsInfosNextLink), Collections.emptyList(), options);
    }

    @Property(name="trainingsAssignedUserCount")
    @JsonIgnore
    public Optional<Integer> getTrainingsAssignedUserCount() {
        return Optional.ofNullable(trainingsAssignedUserCount);
    }

    public TrainingEventsContent withTrainingsAssignedUserCount(Integer trainingsAssignedUserCount) {
        TrainingEventsContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.trainingEventsContent");
        _x.trainingsAssignedUserCount = trainingsAssignedUserCount;
        return _x;
    }

    public TrainingEventsContent withUnmappedField(String name, Object value) {
        TrainingEventsContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AssignedTrainingInfo> assignedTrainingsInfos;
        private String assignedTrainingsInfosNextLink;
        private Integer trainingsAssignedUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedTrainingsInfos(List<AssignedTrainingInfo> assignedTrainingsInfos) {
            this.assignedTrainingsInfos = assignedTrainingsInfos;
            this.changedFields = changedFields.add("assignedTrainingsInfos");
            return this;
        }

        public Builder assignedTrainingsInfos(AssignedTrainingInfo... assignedTrainingsInfos) {
            return assignedTrainingsInfos(Arrays.asList(assignedTrainingsInfos));
        }

        public Builder assignedTrainingsInfosNextLink(String assignedTrainingsInfosNextLink) {
            this.assignedTrainingsInfosNextLink = assignedTrainingsInfosNextLink;
            this.changedFields = changedFields.add("assignedTrainingsInfos");
            return this;
        }

        public Builder trainingsAssignedUserCount(Integer trainingsAssignedUserCount) {
            this.trainingsAssignedUserCount = trainingsAssignedUserCount;
            this.changedFields = changedFields.add("trainingsAssignedUserCount");
            return this;
        }

        public TrainingEventsContent build() {
            TrainingEventsContent _x = new TrainingEventsContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.trainingEventsContent";
            _x.assignedTrainingsInfos = assignedTrainingsInfos;
            _x.assignedTrainingsInfosNextLink = assignedTrainingsInfosNextLink;
            _x.trainingsAssignedUserCount = trainingsAssignedUserCount;
            return _x;
        }
    }

    private TrainingEventsContent _copy() {
        TrainingEventsContent _x = new TrainingEventsContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedTrainingsInfos = assignedTrainingsInfos;
        _x.trainingsAssignedUserCount = trainingsAssignedUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TrainingEventsContent[");
        b.append("assignedTrainingsInfos=");
        b.append(this.assignedTrainingsInfos);
        b.append(", ");
        b.append("trainingsAssignedUserCount=");
        b.append(this.trainingsAssignedUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
