package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ScheduleEntityTheme;

@JsonPropertyOrder({
    "@odata.type", 
    "timeOffReasonId"})
@JsonInclude(Include.NON_NULL)
public class TimeOffItem extends ScheduleEntity implements ODataType {

    @JsonProperty("timeOffReasonId")
    protected String timeOffReasonId;

    protected TimeOffItem() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeOffItem";
    }

    @Property(name="timeOffReasonId")
    @JsonIgnore
    public Optional<String> getTimeOffReasonId() {
        return Optional.ofNullable(timeOffReasonId);
    }

    public TimeOffItem withTimeOffReasonId(String timeOffReasonId) {
        TimeOffItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOffItem");
        _x.timeOffReasonId = timeOffReasonId;
        return _x;
    }

    public TimeOffItem withUnmappedField(String name, Object value) {
        TimeOffItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimeOffItem() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime endDateTime;
        private OffsetDateTime startDateTime;
        private ScheduleEntityTheme theme;
        private String timeOffReasonId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder theme(ScheduleEntityTheme theme) {
            this.theme = theme;
            this.changedFields = changedFields.add("theme");
            return this;
        }

        public Builder timeOffReasonId(String timeOffReasonId) {
            this.timeOffReasonId = timeOffReasonId;
            this.changedFields = changedFields.add("timeOffReasonId");
            return this;
        }

        public TimeOffItem build() {
            TimeOffItem _x = new TimeOffItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeOffItem";
            _x.endDateTime = endDateTime;
            _x.startDateTime = startDateTime;
            _x.theme = theme;
            _x.timeOffReasonId = timeOffReasonId;
            return _x;
        }
    }

    private TimeOffItem _copy() {
        TimeOffItem _x = new TimeOffItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endDateTime = endDateTime;
        _x.startDateTime = startDateTime;
        _x.theme = theme;
        _x.timeOffReasonId = timeOffReasonId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeOffItem[");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("theme=");
        b.append(this.theme);
        b.append(", ");
        b.append("timeOffReasonId=");
        b.append(this.timeOffReasonId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
