package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "approvedLocation"})
@JsonInclude(Include.NON_NULL)
public class TimeClockSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("approvedLocation")
    protected GeoCoordinates approvedLocation;

    protected TimeClockSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeClockSettings";
    }

    @Property(name="approvedLocation")
    @JsonIgnore
    public Optional<GeoCoordinates> getApprovedLocation() {
        return Optional.ofNullable(approvedLocation);
    }

    public TimeClockSettings withApprovedLocation(GeoCoordinates approvedLocation) {
        TimeClockSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeClockSettings");
        _x.approvedLocation = approvedLocation;
        return _x;
    }

    public TimeClockSettings withUnmappedField(String name, Object value) {
        TimeClockSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private GeoCoordinates approvedLocation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder approvedLocation(GeoCoordinates approvedLocation) {
            this.approvedLocation = approvedLocation;
            this.changedFields = changedFields.add("approvedLocation");
            return this;
        }

        public TimeClockSettings build() {
            TimeClockSettings _x = new TimeClockSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeClockSettings";
            _x.approvedLocation = approvedLocation;
            return _x;
        }
    }

    private TimeClockSettings _copy() {
        TimeClockSettings _x = new TimeClockSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.approvedLocation = approvedLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeClockSettings[");
        b.append("approvedLocation=");
        b.append(this.approvedLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
