package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ticketNumber", 
    "ticketSystem"})
@JsonInclude(Include.NON_NULL)
public class TicketInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ticketNumber")
    protected String ticketNumber;

    @JsonProperty("ticketSystem")
    protected String ticketSystem;

    protected TicketInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ticketInfo";
    }

    @Property(name="ticketNumber")
    @JsonIgnore
    public Optional<String> getTicketNumber() {
        return Optional.ofNullable(ticketNumber);
    }

    public TicketInfo withTicketNumber(String ticketNumber) {
        TicketInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ticketInfo");
        _x.ticketNumber = ticketNumber;
        return _x;
    }

    @Property(name="ticketSystem")
    @JsonIgnore
    public Optional<String> getTicketSystem() {
        return Optional.ofNullable(ticketSystem);
    }

    public TicketInfo withTicketSystem(String ticketSystem) {
        TicketInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ticketInfo");
        _x.ticketSystem = ticketSystem;
        return _x;
    }

    public TicketInfo withUnmappedField(String name, Object value) {
        TicketInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ticketNumber;
        private String ticketSystem;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ticketNumber(String ticketNumber) {
            this.ticketNumber = ticketNumber;
            this.changedFields = changedFields.add("ticketNumber");
            return this;
        }

        public Builder ticketSystem(String ticketSystem) {
            this.ticketSystem = ticketSystem;
            this.changedFields = changedFields.add("ticketSystem");
            return this;
        }

        public TicketInfo build() {
            TicketInfo _x = new TicketInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ticketInfo";
            _x.ticketNumber = ticketNumber;
            _x.ticketSystem = ticketSystem;
            return _x;
        }
    }

    private TicketInfo _copy() {
        TicketInfo _x = new TicketInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ticketNumber = ticketNumber;
        _x.ticketSystem = ticketSystem;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TicketInfo[");
        b.append("ticketNumber=");
        b.append(this.ticketNumber);
        b.append(", ");
        b.append("ticketSystem=");
        b.append(this.ticketSystem);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
