package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "callChainId", 
    "cloudServiceDeploymentEnvironment", 
    "cloudServiceDeploymentId", 
    "cloudServiceInstanceName", 
    "cloudServiceName", 
    "deviceDescription", 
    "deviceName", 
    "mediaLegId", 
    "mediaQualityList", 
    "participantId"})
@JsonInclude(Include.NON_NULL)
public class TeleconferenceDeviceQuality implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("callChainId")
    protected UUID callChainId;

    @JsonProperty("cloudServiceDeploymentEnvironment")
    protected String cloudServiceDeploymentEnvironment;

    @JsonProperty("cloudServiceDeploymentId")
    protected String cloudServiceDeploymentId;

    @JsonProperty("cloudServiceInstanceName")
    protected String cloudServiceInstanceName;

    @JsonProperty("cloudServiceName")
    protected String cloudServiceName;

    @JsonProperty("deviceDescription")
    protected String deviceDescription;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("mediaLegId")
    protected UUID mediaLegId;

    @JsonProperty("mediaQualityList")
    protected List<TeleconferenceDeviceMediaQuality> mediaQualityList;

    @JsonProperty("mediaQualityList@nextLink")
    protected String mediaQualityListNextLink;

    @JsonProperty("participantId")
    protected UUID participantId;

    protected TeleconferenceDeviceQuality() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teleconferenceDeviceQuality";
    }

    @Property(name="callChainId")
    @JsonIgnore
    public Optional<UUID> getCallChainId() {
        return Optional.ofNullable(callChainId);
    }

    public TeleconferenceDeviceQuality withCallChainId(UUID callChainId) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.callChainId = callChainId;
        return _x;
    }

    @Property(name="cloudServiceDeploymentEnvironment")
    @JsonIgnore
    public Optional<String> getCloudServiceDeploymentEnvironment() {
        return Optional.ofNullable(cloudServiceDeploymentEnvironment);
    }

    public TeleconferenceDeviceQuality withCloudServiceDeploymentEnvironment(String cloudServiceDeploymentEnvironment) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.cloudServiceDeploymentEnvironment = cloudServiceDeploymentEnvironment;
        return _x;
    }

    @Property(name="cloudServiceDeploymentId")
    @JsonIgnore
    public Optional<String> getCloudServiceDeploymentId() {
        return Optional.ofNullable(cloudServiceDeploymentId);
    }

    public TeleconferenceDeviceQuality withCloudServiceDeploymentId(String cloudServiceDeploymentId) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.cloudServiceDeploymentId = cloudServiceDeploymentId;
        return _x;
    }

    @Property(name="cloudServiceInstanceName")
    @JsonIgnore
    public Optional<String> getCloudServiceInstanceName() {
        return Optional.ofNullable(cloudServiceInstanceName);
    }

    public TeleconferenceDeviceQuality withCloudServiceInstanceName(String cloudServiceInstanceName) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.cloudServiceInstanceName = cloudServiceInstanceName;
        return _x;
    }

    @Property(name="cloudServiceName")
    @JsonIgnore
    public Optional<String> getCloudServiceName() {
        return Optional.ofNullable(cloudServiceName);
    }

    public TeleconferenceDeviceQuality withCloudServiceName(String cloudServiceName) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.cloudServiceName = cloudServiceName;
        return _x;
    }

    @Property(name="deviceDescription")
    @JsonIgnore
    public Optional<String> getDeviceDescription() {
        return Optional.ofNullable(deviceDescription);
    }

    public TeleconferenceDeviceQuality withDeviceDescription(String deviceDescription) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.deviceDescription = deviceDescription;
        return _x;
    }

    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    public TeleconferenceDeviceQuality withDeviceName(String deviceName) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.deviceName = deviceName;
        return _x;
    }

    @Property(name="mediaLegId")
    @JsonIgnore
    public Optional<UUID> getMediaLegId() {
        return Optional.ofNullable(mediaLegId);
    }

    public TeleconferenceDeviceQuality withMediaLegId(UUID mediaLegId) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.mediaLegId = mediaLegId;
        return _x;
    }

    @Property(name="mediaQualityList")
    @JsonIgnore
    public CollectionPage<TeleconferenceDeviceMediaQuality> getMediaQualityList() {
        return new CollectionPage<TeleconferenceDeviceMediaQuality>(contextPath, TeleconferenceDeviceMediaQuality.class, this.mediaQualityList, Optional.ofNullable(mediaQualityListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mediaQualityList")
    @JsonIgnore
    public CollectionPage<TeleconferenceDeviceMediaQuality> getMediaQualityList(HttpRequestOptions options) {
        return new CollectionPage<TeleconferenceDeviceMediaQuality>(contextPath, TeleconferenceDeviceMediaQuality.class, this.mediaQualityList, Optional.ofNullable(mediaQualityListNextLink), Collections.emptyList(), options);
    }

    @Property(name="participantId")
    @JsonIgnore
    public Optional<UUID> getParticipantId() {
        return Optional.ofNullable(participantId);
    }

    public TeleconferenceDeviceQuality withParticipantId(UUID participantId) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceQuality");
        _x.participantId = participantId;
        return _x;
    }

    public TeleconferenceDeviceQuality withUnmappedField(String name, Object value) {
        TeleconferenceDeviceQuality _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID callChainId;
        private String cloudServiceDeploymentEnvironment;
        private String cloudServiceDeploymentId;
        private String cloudServiceInstanceName;
        private String cloudServiceName;
        private String deviceDescription;
        private String deviceName;
        private UUID mediaLegId;
        private List<TeleconferenceDeviceMediaQuality> mediaQualityList;
        private String mediaQualityListNextLink;
        private UUID participantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callChainId(UUID callChainId) {
            this.callChainId = callChainId;
            this.changedFields = changedFields.add("callChainId");
            return this;
        }

        public Builder cloudServiceDeploymentEnvironment(String cloudServiceDeploymentEnvironment) {
            this.cloudServiceDeploymentEnvironment = cloudServiceDeploymentEnvironment;
            this.changedFields = changedFields.add("cloudServiceDeploymentEnvironment");
            return this;
        }

        public Builder cloudServiceDeploymentId(String cloudServiceDeploymentId) {
            this.cloudServiceDeploymentId = cloudServiceDeploymentId;
            this.changedFields = changedFields.add("cloudServiceDeploymentId");
            return this;
        }

        public Builder cloudServiceInstanceName(String cloudServiceInstanceName) {
            this.cloudServiceInstanceName = cloudServiceInstanceName;
            this.changedFields = changedFields.add("cloudServiceInstanceName");
            return this;
        }

        public Builder cloudServiceName(String cloudServiceName) {
            this.cloudServiceName = cloudServiceName;
            this.changedFields = changedFields.add("cloudServiceName");
            return this;
        }

        public Builder deviceDescription(String deviceDescription) {
            this.deviceDescription = deviceDescription;
            this.changedFields = changedFields.add("deviceDescription");
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public Builder mediaLegId(UUID mediaLegId) {
            this.mediaLegId = mediaLegId;
            this.changedFields = changedFields.add("mediaLegId");
            return this;
        }

        public Builder mediaQualityList(List<TeleconferenceDeviceMediaQuality> mediaQualityList) {
            this.mediaQualityList = mediaQualityList;
            this.changedFields = changedFields.add("mediaQualityList");
            return this;
        }

        public Builder mediaQualityList(TeleconferenceDeviceMediaQuality... mediaQualityList) {
            return mediaQualityList(Arrays.asList(mediaQualityList));
        }

        public Builder mediaQualityListNextLink(String mediaQualityListNextLink) {
            this.mediaQualityListNextLink = mediaQualityListNextLink;
            this.changedFields = changedFields.add("mediaQualityList");
            return this;
        }

        public Builder participantId(UUID participantId) {
            this.participantId = participantId;
            this.changedFields = changedFields.add("participantId");
            return this;
        }

        public TeleconferenceDeviceQuality build() {
            TeleconferenceDeviceQuality _x = new TeleconferenceDeviceQuality();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teleconferenceDeviceQuality";
            _x.callChainId = callChainId;
            _x.cloudServiceDeploymentEnvironment = cloudServiceDeploymentEnvironment;
            _x.cloudServiceDeploymentId = cloudServiceDeploymentId;
            _x.cloudServiceInstanceName = cloudServiceInstanceName;
            _x.cloudServiceName = cloudServiceName;
            _x.deviceDescription = deviceDescription;
            _x.deviceName = deviceName;
            _x.mediaLegId = mediaLegId;
            _x.mediaQualityList = mediaQualityList;
            _x.mediaQualityListNextLink = mediaQualityListNextLink;
            _x.participantId = participantId;
            return _x;
        }
    }

    private TeleconferenceDeviceQuality _copy() {
        TeleconferenceDeviceQuality _x = new TeleconferenceDeviceQuality();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callChainId = callChainId;
        _x.cloudServiceDeploymentEnvironment = cloudServiceDeploymentEnvironment;
        _x.cloudServiceDeploymentId = cloudServiceDeploymentId;
        _x.cloudServiceInstanceName = cloudServiceInstanceName;
        _x.cloudServiceName = cloudServiceName;
        _x.deviceDescription = deviceDescription;
        _x.deviceName = deviceName;
        _x.mediaLegId = mediaLegId;
        _x.mediaQualityList = mediaQualityList;
        _x.participantId = participantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeleconferenceDeviceQuality[");
        b.append("callChainId=");
        b.append(this.callChainId);
        b.append(", ");
        b.append("cloudServiceDeploymentEnvironment=");
        b.append(this.cloudServiceDeploymentEnvironment);
        b.append(", ");
        b.append("cloudServiceDeploymentId=");
        b.append(this.cloudServiceDeploymentId);
        b.append(", ");
        b.append("cloudServiceInstanceName=");
        b.append(this.cloudServiceInstanceName);
        b.append(", ");
        b.append("cloudServiceName=");
        b.append(this.cloudServiceName);
        b.append(", ");
        b.append("deviceDescription=");
        b.append(this.deviceDescription);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("mediaLegId=");
        b.append(this.mediaLegId);
        b.append(", ");
        b.append("mediaQualityList=");
        b.append(this.mediaQualityList);
        b.append(", ");
        b.append("participantId=");
        b.append(this.participantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
