package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dateTimeConfiguration", 
    "defaultPassword", 
    "deviceLockTimeout", 
    "isDeviceLockEnabled", 
    "isLoggingEnabled", 
    "isPowerSavingEnabled", 
    "isScreenCaptureEnabled", 
    "isSilentModeEnabled", 
    "language", 
    "lockPin", 
    "loggingLevel", 
    "networkConfiguration"})
@JsonInclude(Include.NON_NULL)
public class TeamworkSystemConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dateTimeConfiguration")
    protected TeamworkDateTimeConfiguration dateTimeConfiguration;

    @JsonProperty("defaultPassword")
    protected String defaultPassword;

    @JsonProperty("deviceLockTimeout")
    protected Duration deviceLockTimeout;

    @JsonProperty("isDeviceLockEnabled")
    protected Boolean isDeviceLockEnabled;

    @JsonProperty("isLoggingEnabled")
    protected Boolean isLoggingEnabled;

    @JsonProperty("isPowerSavingEnabled")
    protected Boolean isPowerSavingEnabled;

    @JsonProperty("isScreenCaptureEnabled")
    protected Boolean isScreenCaptureEnabled;

    @JsonProperty("isSilentModeEnabled")
    protected Boolean isSilentModeEnabled;

    @JsonProperty("language")
    protected String language;

    @JsonProperty("lockPin")
    protected String lockPin;

    @JsonProperty("loggingLevel")
    protected String loggingLevel;

    @JsonProperty("networkConfiguration")
    protected TeamworkNetworkConfiguration networkConfiguration;

    protected TeamworkSystemConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkSystemConfiguration";
    }

    @Property(name="dateTimeConfiguration")
    @JsonIgnore
    public Optional<TeamworkDateTimeConfiguration> getDateTimeConfiguration() {
        return Optional.ofNullable(dateTimeConfiguration);
    }

    public TeamworkSystemConfiguration withDateTimeConfiguration(TeamworkDateTimeConfiguration dateTimeConfiguration) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.dateTimeConfiguration = dateTimeConfiguration;
        return _x;
    }

    @Property(name="defaultPassword")
    @JsonIgnore
    public Optional<String> getDefaultPassword() {
        return Optional.ofNullable(defaultPassword);
    }

    public TeamworkSystemConfiguration withDefaultPassword(String defaultPassword) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.defaultPassword = defaultPassword;
        return _x;
    }

    @Property(name="deviceLockTimeout")
    @JsonIgnore
    public Optional<Duration> getDeviceLockTimeout() {
        return Optional.ofNullable(deviceLockTimeout);
    }

    public TeamworkSystemConfiguration withDeviceLockTimeout(Duration deviceLockTimeout) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.deviceLockTimeout = deviceLockTimeout;
        return _x;
    }

    @Property(name="isDeviceLockEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDeviceLockEnabled() {
        return Optional.ofNullable(isDeviceLockEnabled);
    }

    public TeamworkSystemConfiguration withIsDeviceLockEnabled(Boolean isDeviceLockEnabled) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.isDeviceLockEnabled = isDeviceLockEnabled;
        return _x;
    }

    @Property(name="isLoggingEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsLoggingEnabled() {
        return Optional.ofNullable(isLoggingEnabled);
    }

    public TeamworkSystemConfiguration withIsLoggingEnabled(Boolean isLoggingEnabled) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.isLoggingEnabled = isLoggingEnabled;
        return _x;
    }

    @Property(name="isPowerSavingEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsPowerSavingEnabled() {
        return Optional.ofNullable(isPowerSavingEnabled);
    }

    public TeamworkSystemConfiguration withIsPowerSavingEnabled(Boolean isPowerSavingEnabled) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.isPowerSavingEnabled = isPowerSavingEnabled;
        return _x;
    }

    @Property(name="isScreenCaptureEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsScreenCaptureEnabled() {
        return Optional.ofNullable(isScreenCaptureEnabled);
    }

    public TeamworkSystemConfiguration withIsScreenCaptureEnabled(Boolean isScreenCaptureEnabled) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.isScreenCaptureEnabled = isScreenCaptureEnabled;
        return _x;
    }

    @Property(name="isSilentModeEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsSilentModeEnabled() {
        return Optional.ofNullable(isSilentModeEnabled);
    }

    public TeamworkSystemConfiguration withIsSilentModeEnabled(Boolean isSilentModeEnabled) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.isSilentModeEnabled = isSilentModeEnabled;
        return _x;
    }

    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(language);
    }

    public TeamworkSystemConfiguration withLanguage(String language) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.language = language;
        return _x;
    }

    @Property(name="lockPin")
    @JsonIgnore
    public Optional<String> getLockPin() {
        return Optional.ofNullable(lockPin);
    }

    public TeamworkSystemConfiguration withLockPin(String lockPin) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.lockPin = lockPin;
        return _x;
    }

    @Property(name="loggingLevel")
    @JsonIgnore
    public Optional<String> getLoggingLevel() {
        return Optional.ofNullable(loggingLevel);
    }

    public TeamworkSystemConfiguration withLoggingLevel(String loggingLevel) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.loggingLevel = loggingLevel;
        return _x;
    }

    @Property(name="networkConfiguration")
    @JsonIgnore
    public Optional<TeamworkNetworkConfiguration> getNetworkConfiguration() {
        return Optional.ofNullable(networkConfiguration);
    }

    public TeamworkSystemConfiguration withNetworkConfiguration(TeamworkNetworkConfiguration networkConfiguration) {
        TeamworkSystemConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSystemConfiguration");
        _x.networkConfiguration = networkConfiguration;
        return _x;
    }

    public TeamworkSystemConfiguration withUnmappedField(String name, Object value) {
        TeamworkSystemConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkDateTimeConfiguration dateTimeConfiguration;
        private String defaultPassword;
        private Duration deviceLockTimeout;
        private Boolean isDeviceLockEnabled;
        private Boolean isLoggingEnabled;
        private Boolean isPowerSavingEnabled;
        private Boolean isScreenCaptureEnabled;
        private Boolean isSilentModeEnabled;
        private String language;
        private String lockPin;
        private String loggingLevel;
        private TeamworkNetworkConfiguration networkConfiguration;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder dateTimeConfiguration(TeamworkDateTimeConfiguration dateTimeConfiguration) {
            this.dateTimeConfiguration = dateTimeConfiguration;
            this.changedFields = changedFields.add("dateTimeConfiguration");
            return this;
        }

        public Builder defaultPassword(String defaultPassword) {
            this.defaultPassword = defaultPassword;
            this.changedFields = changedFields.add("defaultPassword");
            return this;
        }

        public Builder deviceLockTimeout(Duration deviceLockTimeout) {
            this.deviceLockTimeout = deviceLockTimeout;
            this.changedFields = changedFields.add("deviceLockTimeout");
            return this;
        }

        public Builder isDeviceLockEnabled(Boolean isDeviceLockEnabled) {
            this.isDeviceLockEnabled = isDeviceLockEnabled;
            this.changedFields = changedFields.add("isDeviceLockEnabled");
            return this;
        }

        public Builder isLoggingEnabled(Boolean isLoggingEnabled) {
            this.isLoggingEnabled = isLoggingEnabled;
            this.changedFields = changedFields.add("isLoggingEnabled");
            return this;
        }

        public Builder isPowerSavingEnabled(Boolean isPowerSavingEnabled) {
            this.isPowerSavingEnabled = isPowerSavingEnabled;
            this.changedFields = changedFields.add("isPowerSavingEnabled");
            return this;
        }

        public Builder isScreenCaptureEnabled(Boolean isScreenCaptureEnabled) {
            this.isScreenCaptureEnabled = isScreenCaptureEnabled;
            this.changedFields = changedFields.add("isScreenCaptureEnabled");
            return this;
        }

        public Builder isSilentModeEnabled(Boolean isSilentModeEnabled) {
            this.isSilentModeEnabled = isSilentModeEnabled;
            this.changedFields = changedFields.add("isSilentModeEnabled");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public Builder lockPin(String lockPin) {
            this.lockPin = lockPin;
            this.changedFields = changedFields.add("lockPin");
            return this;
        }

        public Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            this.changedFields = changedFields.add("loggingLevel");
            return this;
        }

        public Builder networkConfiguration(TeamworkNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.changedFields = changedFields.add("networkConfiguration");
            return this;
        }

        public TeamworkSystemConfiguration build() {
            TeamworkSystemConfiguration _x = new TeamworkSystemConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkSystemConfiguration";
            _x.dateTimeConfiguration = dateTimeConfiguration;
            _x.defaultPassword = defaultPassword;
            _x.deviceLockTimeout = deviceLockTimeout;
            _x.isDeviceLockEnabled = isDeviceLockEnabled;
            _x.isLoggingEnabled = isLoggingEnabled;
            _x.isPowerSavingEnabled = isPowerSavingEnabled;
            _x.isScreenCaptureEnabled = isScreenCaptureEnabled;
            _x.isSilentModeEnabled = isSilentModeEnabled;
            _x.language = language;
            _x.lockPin = lockPin;
            _x.loggingLevel = loggingLevel;
            _x.networkConfiguration = networkConfiguration;
            return _x;
        }
    }

    private TeamworkSystemConfiguration _copy() {
        TeamworkSystemConfiguration _x = new TeamworkSystemConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dateTimeConfiguration = dateTimeConfiguration;
        _x.defaultPassword = defaultPassword;
        _x.deviceLockTimeout = deviceLockTimeout;
        _x.isDeviceLockEnabled = isDeviceLockEnabled;
        _x.isLoggingEnabled = isLoggingEnabled;
        _x.isPowerSavingEnabled = isPowerSavingEnabled;
        _x.isScreenCaptureEnabled = isScreenCaptureEnabled;
        _x.isSilentModeEnabled = isSilentModeEnabled;
        _x.language = language;
        _x.lockPin = lockPin;
        _x.loggingLevel = loggingLevel;
        _x.networkConfiguration = networkConfiguration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkSystemConfiguration[");
        b.append("dateTimeConfiguration=");
        b.append(this.dateTimeConfiguration);
        b.append(", ");
        b.append("defaultPassword=");
        b.append(this.defaultPassword);
        b.append(", ");
        b.append("deviceLockTimeout=");
        b.append(this.deviceLockTimeout);
        b.append(", ");
        b.append("isDeviceLockEnabled=");
        b.append(this.isDeviceLockEnabled);
        b.append(", ");
        b.append("isLoggingEnabled=");
        b.append(this.isLoggingEnabled);
        b.append(", ");
        b.append("isPowerSavingEnabled=");
        b.append(this.isPowerSavingEnabled);
        b.append(", ");
        b.append("isScreenCaptureEnabled=");
        b.append(this.isScreenCaptureEnabled);
        b.append(", ");
        b.append("isSilentModeEnabled=");
        b.append(this.isSilentModeEnabled);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("lockPin=");
        b.append(this.lockPin);
        b.append(", ");
        b.append("loggingLevel=");
        b.append(this.loggingLevel);
        b.append(", ");
        b.append("networkConfiguration=");
        b.append(this.networkConfiguration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
