package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamworkPeripheral;

@JsonPropertyOrder({
    "@odata.type", 
    "isCommunicationSpeakerOptional", 
    "isSpeakerOptional", 
    "defaultCommunicationSpeaker", 
    "defaultSpeaker", 
    "speakers"})
@JsonInclude(Include.NON_NULL)
public class TeamworkSpeakerConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isCommunicationSpeakerOptional")
    protected Boolean isCommunicationSpeakerOptional;

    @JsonProperty("isSpeakerOptional")
    protected Boolean isSpeakerOptional;

    @JsonProperty("defaultCommunicationSpeaker")
    protected TeamworkPeripheral defaultCommunicationSpeaker;

    @JsonProperty("defaultSpeaker")
    protected TeamworkPeripheral defaultSpeaker;

    @JsonProperty("speakers")
    protected List<TeamworkPeripheral> speakers;

    protected TeamworkSpeakerConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkSpeakerConfiguration";
    }

    @Property(name="isCommunicationSpeakerOptional")
    @JsonIgnore
    public Optional<Boolean> getIsCommunicationSpeakerOptional() {
        return Optional.ofNullable(isCommunicationSpeakerOptional);
    }

    public TeamworkSpeakerConfiguration withIsCommunicationSpeakerOptional(Boolean isCommunicationSpeakerOptional) {
        TeamworkSpeakerConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSpeakerConfiguration");
        _x.isCommunicationSpeakerOptional = isCommunicationSpeakerOptional;
        return _x;
    }

    @Property(name="isSpeakerOptional")
    @JsonIgnore
    public Optional<Boolean> getIsSpeakerOptional() {
        return Optional.ofNullable(isSpeakerOptional);
    }

    public TeamworkSpeakerConfiguration withIsSpeakerOptional(Boolean isSpeakerOptional) {
        TeamworkSpeakerConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSpeakerConfiguration");
        _x.isSpeakerOptional = isSpeakerOptional;
        return _x;
    }

    public TeamworkSpeakerConfiguration withUnmappedField(String name, Object value) {
        TeamworkSpeakerConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isCommunicationSpeakerOptional;
        private Boolean isSpeakerOptional;
        private TeamworkPeripheral defaultCommunicationSpeaker;
        private TeamworkPeripheral defaultSpeaker;
        private List<TeamworkPeripheral> speakers;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isCommunicationSpeakerOptional(Boolean isCommunicationSpeakerOptional) {
            this.isCommunicationSpeakerOptional = isCommunicationSpeakerOptional;
            this.changedFields = changedFields.add("isCommunicationSpeakerOptional");
            return this;
        }

        public Builder isSpeakerOptional(Boolean isSpeakerOptional) {
            this.isSpeakerOptional = isSpeakerOptional;
            this.changedFields = changedFields.add("isSpeakerOptional");
            return this;
        }

        public Builder defaultCommunicationSpeaker(TeamworkPeripheral defaultCommunicationSpeaker) {
            this.defaultCommunicationSpeaker = defaultCommunicationSpeaker;
            this.changedFields = changedFields.add("defaultCommunicationSpeaker");
            return this;
        }

        public Builder defaultSpeaker(TeamworkPeripheral defaultSpeaker) {
            this.defaultSpeaker = defaultSpeaker;
            this.changedFields = changedFields.add("defaultSpeaker");
            return this;
        }

        public Builder speakers(List<TeamworkPeripheral> speakers) {
            this.speakers = speakers;
            this.changedFields = changedFields.add("speakers");
            return this;
        }

        public Builder speakers(TeamworkPeripheral... speakers) {
            return speakers(Arrays.asList(speakers));
        }

        public TeamworkSpeakerConfiguration build() {
            TeamworkSpeakerConfiguration _x = new TeamworkSpeakerConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkSpeakerConfiguration";
            _x.isCommunicationSpeakerOptional = isCommunicationSpeakerOptional;
            _x.isSpeakerOptional = isSpeakerOptional;
            _x.defaultCommunicationSpeaker = defaultCommunicationSpeaker;
            _x.defaultSpeaker = defaultSpeaker;
            _x.speakers = speakers;
            return _x;
        }
    }

    private TeamworkSpeakerConfiguration _copy() {
        TeamworkSpeakerConfiguration _x = new TeamworkSpeakerConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isCommunicationSpeakerOptional = isCommunicationSpeakerOptional;
        _x.isSpeakerOptional = isSpeakerOptional;
        _x.defaultCommunicationSpeaker = defaultCommunicationSpeaker;
        _x.defaultSpeaker = defaultSpeaker;
        _x.speakers = speakers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkSpeakerConfiguration[");
        b.append("isCommunicationSpeakerOptional=");
        b.append(this.isCommunicationSpeakerOptional);
        b.append(", ");
        b.append("isSpeakerOptional=");
        b.append(this.isSpeakerOptional);
        b.append(", ");
        b.append("defaultCommunicationSpeaker=");
        b.append(this.defaultCommunicationSpeaker);
        b.append(", ");
        b.append("defaultSpeaker=");
        b.append(this.defaultSpeaker);
        b.append(", ");
        b.append("speakers=");
        b.append(this.speakers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
