package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "connection", 
    "isOptional"})
@JsonInclude(Include.NON_NULL)
public class TeamworkPeripheralHealth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("connection")
    protected TeamworkConnection connection;

    @JsonProperty("isOptional")
    protected Boolean isOptional;

    protected TeamworkPeripheralHealth() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkPeripheralHealth";
    }

    @Property(name="connection")
    @JsonIgnore
    public Optional<TeamworkConnection> getConnection() {
        return Optional.ofNullable(connection);
    }

    public TeamworkPeripheralHealth withConnection(TeamworkConnection connection) {
        TeamworkPeripheralHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralHealth");
        _x.connection = connection;
        return _x;
    }

    @Property(name="isOptional")
    @JsonIgnore
    public Optional<Boolean> getIsOptional() {
        return Optional.ofNullable(isOptional);
    }

    public TeamworkPeripheralHealth withIsOptional(Boolean isOptional) {
        TeamworkPeripheralHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralHealth");
        _x.isOptional = isOptional;
        return _x;
    }

    public TeamworkPeripheralHealth withUnmappedField(String name, Object value) {
        TeamworkPeripheralHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkConnection connection;
        private Boolean isOptional;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder connection(TeamworkConnection connection) {
            this.connection = connection;
            this.changedFields = changedFields.add("connection");
            return this;
        }

        public Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            this.changedFields = changedFields.add("isOptional");
            return this;
        }

        public TeamworkPeripheralHealth build() {
            TeamworkPeripheralHealth _x = new TeamworkPeripheralHealth();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkPeripheralHealth";
            _x.connection = connection;
            _x.isOptional = isOptional;
            return _x;
        }
    }

    private TeamworkPeripheralHealth _copy() {
        TeamworkPeripheralHealth _x = new TeamworkPeripheralHealth();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.connection = connection;
        _x.isOptional = isOptional;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkPeripheralHealth[");
        b.append("connection=");
        b.append(this.connection);
        b.append(", ");
        b.append("isOptional=");
        b.append(this.isOptional);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
