package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "calendarEventId", 
    "joinWebUrl", 
    "organizer"})
@JsonInclude(Include.NON_NULL)
public class TeamworkOnlineMeetingInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("calendarEventId")
    protected String calendarEventId;

    @JsonProperty("joinWebUrl")
    protected String joinWebUrl;

    @JsonProperty("organizer")
    protected TeamworkUserIdentity organizer;

    protected TeamworkOnlineMeetingInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkOnlineMeetingInfo";
    }

    @Property(name="calendarEventId")
    @JsonIgnore
    public Optional<String> getCalendarEventId() {
        return Optional.ofNullable(calendarEventId);
    }

    public TeamworkOnlineMeetingInfo withCalendarEventId(String calendarEventId) {
        TeamworkOnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkOnlineMeetingInfo");
        _x.calendarEventId = calendarEventId;
        return _x;
    }

    @Property(name="joinWebUrl")
    @JsonIgnore
    public Optional<String> getJoinWebUrl() {
        return Optional.ofNullable(joinWebUrl);
    }

    public TeamworkOnlineMeetingInfo withJoinWebUrl(String joinWebUrl) {
        TeamworkOnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkOnlineMeetingInfo");
        _x.joinWebUrl = joinWebUrl;
        return _x;
    }

    @Property(name="organizer")
    @JsonIgnore
    public Optional<TeamworkUserIdentity> getOrganizer() {
        return Optional.ofNullable(organizer);
    }

    public TeamworkOnlineMeetingInfo withOrganizer(TeamworkUserIdentity organizer) {
        TeamworkOnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkOnlineMeetingInfo");
        _x.organizer = organizer;
        return _x;
    }

    public TeamworkOnlineMeetingInfo withUnmappedField(String name, Object value) {
        TeamworkOnlineMeetingInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String calendarEventId;
        private String joinWebUrl;
        private TeamworkUserIdentity organizer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder calendarEventId(String calendarEventId) {
            this.calendarEventId = calendarEventId;
            this.changedFields = changedFields.add("calendarEventId");
            return this;
        }

        public Builder joinWebUrl(String joinWebUrl) {
            this.joinWebUrl = joinWebUrl;
            this.changedFields = changedFields.add("joinWebUrl");
            return this;
        }

        public Builder organizer(TeamworkUserIdentity organizer) {
            this.organizer = organizer;
            this.changedFields = changedFields.add("organizer");
            return this;
        }

        public TeamworkOnlineMeetingInfo build() {
            TeamworkOnlineMeetingInfo _x = new TeamworkOnlineMeetingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkOnlineMeetingInfo";
            _x.calendarEventId = calendarEventId;
            _x.joinWebUrl = joinWebUrl;
            _x.organizer = organizer;
            return _x;
        }
    }

    private TeamworkOnlineMeetingInfo _copy() {
        TeamworkOnlineMeetingInfo _x = new TeamworkOnlineMeetingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.calendarEventId = calendarEventId;
        _x.joinWebUrl = joinWebUrl;
        _x.organizer = organizer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkOnlineMeetingInfo[");
        b.append("calendarEventId=");
        b.append(this.calendarEventId);
        b.append(", ");
        b.append("joinWebUrl=");
        b.append(this.joinWebUrl);
        b.append(", ");
        b.append("organizer=");
        b.append(this.organizer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
