package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultGateway", 
    "domainName", 
    "hostName", 
    "ipAddress", 
    "isDhcpEnabled", 
    "isPCPortEnabled", 
    "primaryDns", 
    "secondaryDns", 
    "subnetMask"})
@JsonInclude(Include.NON_NULL)
public class TeamworkNetworkConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("defaultGateway")
    protected String defaultGateway;

    @JsonProperty("domainName")
    protected String domainName;

    @JsonProperty("hostName")
    protected String hostName;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("isDhcpEnabled")
    protected Boolean isDhcpEnabled;

    @JsonProperty("isPCPortEnabled")
    protected Boolean isPCPortEnabled;

    @JsonProperty("primaryDns")
    protected String primaryDns;

    @JsonProperty("secondaryDns")
    protected String secondaryDns;

    @JsonProperty("subnetMask")
    protected String subnetMask;

    protected TeamworkNetworkConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkNetworkConfiguration";
    }

    @Property(name="defaultGateway")
    @JsonIgnore
    public Optional<String> getDefaultGateway() {
        return Optional.ofNullable(defaultGateway);
    }

    public TeamworkNetworkConfiguration withDefaultGateway(String defaultGateway) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.defaultGateway = defaultGateway;
        return _x;
    }

    @Property(name="domainName")
    @JsonIgnore
    public Optional<String> getDomainName() {
        return Optional.ofNullable(domainName);
    }

    public TeamworkNetworkConfiguration withDomainName(String domainName) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.domainName = domainName;
        return _x;
    }

    @Property(name="hostName")
    @JsonIgnore
    public Optional<String> getHostName() {
        return Optional.ofNullable(hostName);
    }

    public TeamworkNetworkConfiguration withHostName(String hostName) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.hostName = hostName;
        return _x;
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public TeamworkNetworkConfiguration withIpAddress(String ipAddress) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="isDhcpEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDhcpEnabled() {
        return Optional.ofNullable(isDhcpEnabled);
    }

    public TeamworkNetworkConfiguration withIsDhcpEnabled(Boolean isDhcpEnabled) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.isDhcpEnabled = isDhcpEnabled;
        return _x;
    }

    @Property(name="isPCPortEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsPCPortEnabled() {
        return Optional.ofNullable(isPCPortEnabled);
    }

    public TeamworkNetworkConfiguration withIsPCPortEnabled(Boolean isPCPortEnabled) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.isPCPortEnabled = isPCPortEnabled;
        return _x;
    }

    @Property(name="primaryDns")
    @JsonIgnore
    public Optional<String> getPrimaryDns() {
        return Optional.ofNullable(primaryDns);
    }

    public TeamworkNetworkConfiguration withPrimaryDns(String primaryDns) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.primaryDns = primaryDns;
        return _x;
    }

    @Property(name="secondaryDns")
    @JsonIgnore
    public Optional<String> getSecondaryDns() {
        return Optional.ofNullable(secondaryDns);
    }

    public TeamworkNetworkConfiguration withSecondaryDns(String secondaryDns) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.secondaryDns = secondaryDns;
        return _x;
    }

    @Property(name="subnetMask")
    @JsonIgnore
    public Optional<String> getSubnetMask() {
        return Optional.ofNullable(subnetMask);
    }

    public TeamworkNetworkConfiguration withSubnetMask(String subnetMask) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkNetworkConfiguration");
        _x.subnetMask = subnetMask;
        return _x;
    }

    public TeamworkNetworkConfiguration withUnmappedField(String name, Object value) {
        TeamworkNetworkConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String defaultGateway;
        private String domainName;
        private String hostName;
        private String ipAddress;
        private Boolean isDhcpEnabled;
        private Boolean isPCPortEnabled;
        private String primaryDns;
        private String secondaryDns;
        private String subnetMask;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder defaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
            this.changedFields = changedFields.add("defaultGateway");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.changedFields = changedFields.add("domainName");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.changedFields = changedFields.add("hostName");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder isDhcpEnabled(Boolean isDhcpEnabled) {
            this.isDhcpEnabled = isDhcpEnabled;
            this.changedFields = changedFields.add("isDhcpEnabled");
            return this;
        }

        public Builder isPCPortEnabled(Boolean isPCPortEnabled) {
            this.isPCPortEnabled = isPCPortEnabled;
            this.changedFields = changedFields.add("isPCPortEnabled");
            return this;
        }

        public Builder primaryDns(String primaryDns) {
            this.primaryDns = primaryDns;
            this.changedFields = changedFields.add("primaryDns");
            return this;
        }

        public Builder secondaryDns(String secondaryDns) {
            this.secondaryDns = secondaryDns;
            this.changedFields = changedFields.add("secondaryDns");
            return this;
        }

        public Builder subnetMask(String subnetMask) {
            this.subnetMask = subnetMask;
            this.changedFields = changedFields.add("subnetMask");
            return this;
        }

        public TeamworkNetworkConfiguration build() {
            TeamworkNetworkConfiguration _x = new TeamworkNetworkConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkNetworkConfiguration";
            _x.defaultGateway = defaultGateway;
            _x.domainName = domainName;
            _x.hostName = hostName;
            _x.ipAddress = ipAddress;
            _x.isDhcpEnabled = isDhcpEnabled;
            _x.isPCPortEnabled = isPCPortEnabled;
            _x.primaryDns = primaryDns;
            _x.secondaryDns = secondaryDns;
            _x.subnetMask = subnetMask;
            return _x;
        }
    }

    private TeamworkNetworkConfiguration _copy() {
        TeamworkNetworkConfiguration _x = new TeamworkNetworkConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.defaultGateway = defaultGateway;
        _x.domainName = domainName;
        _x.hostName = hostName;
        _x.ipAddress = ipAddress;
        _x.isDhcpEnabled = isDhcpEnabled;
        _x.isPCPortEnabled = isPCPortEnabled;
        _x.primaryDns = primaryDns;
        _x.secondaryDns = secondaryDns;
        _x.subnetMask = subnetMask;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkNetworkConfiguration[");
        b.append("defaultGateway=");
        b.append(this.defaultGateway);
        b.append(", ");
        b.append("domainName=");
        b.append(this.domainName);
        b.append(", ");
        b.append("hostName=");
        b.append(this.hostName);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("isDhcpEnabled=");
        b.append(this.isDhcpEnabled);
        b.append(", ");
        b.append("isPCPortEnabled=");
        b.append(this.isPCPortEnabled);
        b.append(", ");
        b.append("primaryDns=");
        b.append(this.primaryDns);
        b.append(", ");
        b.append("secondaryDns=");
        b.append(this.secondaryDns);
        b.append(", ");
        b.append("subnetMask=");
        b.append(this.subnetMask);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
