package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "computeHealth", 
    "hdmiIngestHealth"})
@JsonInclude(Include.NON_NULL)
public class TeamworkHardwareHealth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("computeHealth")
    protected TeamworkPeripheralHealth computeHealth;

    @JsonProperty("hdmiIngestHealth")
    protected TeamworkPeripheralHealth hdmiIngestHealth;

    protected TeamworkHardwareHealth() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkHardwareHealth";
    }

    @Property(name="computeHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getComputeHealth() {
        return Optional.ofNullable(computeHealth);
    }

    public TeamworkHardwareHealth withComputeHealth(TeamworkPeripheralHealth computeHealth) {
        TeamworkHardwareHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkHardwareHealth");
        _x.computeHealth = computeHealth;
        return _x;
    }

    @Property(name="hdmiIngestHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getHdmiIngestHealth() {
        return Optional.ofNullable(hdmiIngestHealth);
    }

    public TeamworkHardwareHealth withHdmiIngestHealth(TeamworkPeripheralHealth hdmiIngestHealth) {
        TeamworkHardwareHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkHardwareHealth");
        _x.hdmiIngestHealth = hdmiIngestHealth;
        return _x;
    }

    public TeamworkHardwareHealth withUnmappedField(String name, Object value) {
        TeamworkHardwareHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkPeripheralHealth computeHealth;
        private TeamworkPeripheralHealth hdmiIngestHealth;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder computeHealth(TeamworkPeripheralHealth computeHealth) {
            this.computeHealth = computeHealth;
            this.changedFields = changedFields.add("computeHealth");
            return this;
        }

        public Builder hdmiIngestHealth(TeamworkPeripheralHealth hdmiIngestHealth) {
            this.hdmiIngestHealth = hdmiIngestHealth;
            this.changedFields = changedFields.add("hdmiIngestHealth");
            return this;
        }

        public TeamworkHardwareHealth build() {
            TeamworkHardwareHealth _x = new TeamworkHardwareHealth();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkHardwareHealth";
            _x.computeHealth = computeHealth;
            _x.hdmiIngestHealth = hdmiIngestHealth;
            return _x;
        }
    }

    private TeamworkHardwareHealth _copy() {
        TeamworkHardwareHealth _x = new TeamworkHardwareHealth();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.computeHealth = computeHealth;
        _x.hdmiIngestHealth = hdmiIngestHealth;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkHardwareHealth[");
        b.append("computeHealth=");
        b.append(this.computeHealth);
        b.append(", ");
        b.append("hdmiIngestHealth=");
        b.append(this.hdmiIngestHealth);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
