package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isContentCameraInverted", 
    "isContentCameraOptional", 
    "isContentEnhancementEnabled"})
@JsonInclude(Include.NON_NULL)
public class TeamworkContentCameraConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isContentCameraInverted")
    protected Boolean isContentCameraInverted;

    @JsonProperty("isContentCameraOptional")
    protected Boolean isContentCameraOptional;

    @JsonProperty("isContentEnhancementEnabled")
    protected Boolean isContentEnhancementEnabled;

    protected TeamworkContentCameraConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkContentCameraConfiguration";
    }

    @Property(name="isContentCameraInverted")
    @JsonIgnore
    public Optional<Boolean> getIsContentCameraInverted() {
        return Optional.ofNullable(isContentCameraInverted);
    }

    public TeamworkContentCameraConfiguration withIsContentCameraInverted(Boolean isContentCameraInverted) {
        TeamworkContentCameraConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkContentCameraConfiguration");
        _x.isContentCameraInverted = isContentCameraInverted;
        return _x;
    }

    @Property(name="isContentCameraOptional")
    @JsonIgnore
    public Optional<Boolean> getIsContentCameraOptional() {
        return Optional.ofNullable(isContentCameraOptional);
    }

    public TeamworkContentCameraConfiguration withIsContentCameraOptional(Boolean isContentCameraOptional) {
        TeamworkContentCameraConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkContentCameraConfiguration");
        _x.isContentCameraOptional = isContentCameraOptional;
        return _x;
    }

    @Property(name="isContentEnhancementEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsContentEnhancementEnabled() {
        return Optional.ofNullable(isContentEnhancementEnabled);
    }

    public TeamworkContentCameraConfiguration withIsContentEnhancementEnabled(Boolean isContentEnhancementEnabled) {
        TeamworkContentCameraConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkContentCameraConfiguration");
        _x.isContentEnhancementEnabled = isContentEnhancementEnabled;
        return _x;
    }

    public TeamworkContentCameraConfiguration withUnmappedField(String name, Object value) {
        TeamworkContentCameraConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isContentCameraInverted;
        private Boolean isContentCameraOptional;
        private Boolean isContentEnhancementEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isContentCameraInverted(Boolean isContentCameraInverted) {
            this.isContentCameraInverted = isContentCameraInverted;
            this.changedFields = changedFields.add("isContentCameraInverted");
            return this;
        }

        public Builder isContentCameraOptional(Boolean isContentCameraOptional) {
            this.isContentCameraOptional = isContentCameraOptional;
            this.changedFields = changedFields.add("isContentCameraOptional");
            return this;
        }

        public Builder isContentEnhancementEnabled(Boolean isContentEnhancementEnabled) {
            this.isContentEnhancementEnabled = isContentEnhancementEnabled;
            this.changedFields = changedFields.add("isContentEnhancementEnabled");
            return this;
        }

        public TeamworkContentCameraConfiguration build() {
            TeamworkContentCameraConfiguration _x = new TeamworkContentCameraConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkContentCameraConfiguration";
            _x.isContentCameraInverted = isContentCameraInverted;
            _x.isContentCameraOptional = isContentCameraOptional;
            _x.isContentEnhancementEnabled = isContentEnhancementEnabled;
            return _x;
        }
    }

    private TeamworkContentCameraConfiguration _copy() {
        TeamworkContentCameraConfiguration _x = new TeamworkContentCameraConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isContentCameraInverted = isContentCameraInverted;
        _x.isContentCameraOptional = isContentCameraOptional;
        _x.isContentEnhancementEnabled = isContentEnhancementEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkContentCameraConfiguration[");
        b.append("isContentCameraInverted=");
        b.append(this.isContentCameraInverted);
        b.append(", ");
        b.append("isContentCameraOptional=");
        b.append(this.isContentCameraOptional);
        b.append(", ");
        b.append("isContentEnhancementEnabled=");
        b.append(this.isContentEnhancementEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
