package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkConnectionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "connectionStatus", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class TeamworkConnection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("connectionStatus")
    protected TeamworkConnectionStatus connectionStatus;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected TeamworkConnection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkConnection";
    }

    @Property(name="connectionStatus")
    @JsonIgnore
    public Optional<TeamworkConnectionStatus> getConnectionStatus() {
        return Optional.ofNullable(connectionStatus);
    }

    public TeamworkConnection withConnectionStatus(TeamworkConnectionStatus connectionStatus) {
        TeamworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkConnection");
        _x.connectionStatus = connectionStatus;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TeamworkConnection withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TeamworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkConnection");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public TeamworkConnection withUnmappedField(String name, Object value) {
        TeamworkConnection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkConnectionStatus connectionStatus;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder connectionStatus(TeamworkConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            this.changedFields = changedFields.add("connectionStatus");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public TeamworkConnection build() {
            TeamworkConnection _x = new TeamworkConnection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkConnection";
            _x.connectionStatus = connectionStatus;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    private TeamworkConnection _copy() {
        TeamworkConnection _x = new TeamworkConnection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.connectionStatus = connectionStatus;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkConnection[");
        b.append("connectionStatus=");
        b.append(this.connectionStatus);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
