package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamworkPeripheral;

@JsonPropertyOrder({
    "@odata.type", 
    "contentCameraConfiguration", 
    "cameras", 
    "defaultContentCamera"})
@JsonInclude(Include.NON_NULL)
public class TeamworkCameraConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentCameraConfiguration")
    protected TeamworkContentCameraConfiguration contentCameraConfiguration;

    @JsonProperty("cameras")
    protected List<TeamworkPeripheral> cameras;

    @JsonProperty("defaultContentCamera")
    protected TeamworkPeripheral defaultContentCamera;

    protected TeamworkCameraConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkCameraConfiguration";
    }

    @Property(name="contentCameraConfiguration")
    @JsonIgnore
    public Optional<TeamworkContentCameraConfiguration> getContentCameraConfiguration() {
        return Optional.ofNullable(contentCameraConfiguration);
    }

    public TeamworkCameraConfiguration withContentCameraConfiguration(TeamworkContentCameraConfiguration contentCameraConfiguration) {
        TeamworkCameraConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkCameraConfiguration");
        _x.contentCameraConfiguration = contentCameraConfiguration;
        return _x;
    }

    public TeamworkCameraConfiguration withUnmappedField(String name, Object value) {
        TeamworkCameraConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkContentCameraConfiguration contentCameraConfiguration;
        private List<TeamworkPeripheral> cameras;
        private TeamworkPeripheral defaultContentCamera;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contentCameraConfiguration(TeamworkContentCameraConfiguration contentCameraConfiguration) {
            this.contentCameraConfiguration = contentCameraConfiguration;
            this.changedFields = changedFields.add("contentCameraConfiguration");
            return this;
        }

        public Builder cameras(List<TeamworkPeripheral> cameras) {
            this.cameras = cameras;
            this.changedFields = changedFields.add("cameras");
            return this;
        }

        public Builder cameras(TeamworkPeripheral... cameras) {
            return cameras(Arrays.asList(cameras));
        }

        public Builder defaultContentCamera(TeamworkPeripheral defaultContentCamera) {
            this.defaultContentCamera = defaultContentCamera;
            this.changedFields = changedFields.add("defaultContentCamera");
            return this;
        }

        public TeamworkCameraConfiguration build() {
            TeamworkCameraConfiguration _x = new TeamworkCameraConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkCameraConfiguration";
            _x.contentCameraConfiguration = contentCameraConfiguration;
            _x.cameras = cameras;
            _x.defaultContentCamera = defaultContentCamera;
            return _x;
        }
    }

    private TeamworkCameraConfiguration _copy() {
        TeamworkCameraConfiguration _x = new TeamworkCameraConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contentCameraConfiguration = contentCameraConfiguration;
        _x.cameras = cameras;
        _x.defaultContentCamera = defaultContentCamera;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkCameraConfiguration[");
        b.append("contentCameraConfiguration=");
        b.append(this.contentCameraConfiguration);
        b.append(", ");
        b.append("cameras=");
        b.append(this.cameras);
        b.append(", ");
        b.append("defaultContentCamera=");
        b.append(this.defaultContentCamera);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
