package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkActivityTopicSource;

@JsonPropertyOrder({
    "@odata.type", 
    "source", 
    "value", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class TeamworkActivityTopic implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("source")
    protected TeamworkActivityTopicSource source;

    @JsonProperty("value")
    protected String value;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected TeamworkActivityTopic() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkActivityTopic";
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<TeamworkActivityTopicSource> getSource() {
        return Optional.ofNullable(source);
    }

    public TeamworkActivityTopic withSource(TeamworkActivityTopicSource source) {
        TeamworkActivityTopic _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkActivityTopic");
        _x.source = source;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public TeamworkActivityTopic withValue(String value) {
        TeamworkActivityTopic _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkActivityTopic");
        _x.value = value;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public TeamworkActivityTopic withWebUrl(String webUrl) {
        TeamworkActivityTopic _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkActivityTopic");
        _x.webUrl = webUrl;
        return _x;
    }

    public TeamworkActivityTopic withUnmappedField(String name, Object value) {
        TeamworkActivityTopic _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkActivityTopicSource source;
        private String value;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder source(TeamworkActivityTopicSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public TeamworkActivityTopic build() {
            TeamworkActivityTopic _x = new TeamworkActivityTopic();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkActivityTopic";
            _x.source = source;
            _x.value = value;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private TeamworkActivityTopic _copy() {
        TeamworkActivityTopic _x = new TeamworkActivityTopic();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.source = source;
        _x.value = value;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkActivityTopic[");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
