package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "initiator", 
    "teamsAppDisplayName", 
    "teamsAppId"})
@JsonInclude(Include.NON_NULL)
public class TeamsAppUpgradedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("teamsAppDisplayName")
    protected String teamsAppDisplayName;

    @JsonProperty("teamsAppId")
    protected String teamsAppId;

    protected TeamsAppUpgradedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsAppUpgradedEventMessageDetail";
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public TeamsAppUpgradedEventMessageDetail withInitiator(IdentitySet initiator) {
        TeamsAppUpgradedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppUpgradedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="teamsAppDisplayName")
    @JsonIgnore
    public Optional<String> getTeamsAppDisplayName() {
        return Optional.ofNullable(teamsAppDisplayName);
    }

    public TeamsAppUpgradedEventMessageDetail withTeamsAppDisplayName(String teamsAppDisplayName) {
        TeamsAppUpgradedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppUpgradedEventMessageDetail");
        _x.teamsAppDisplayName = teamsAppDisplayName;
        return _x;
    }

    @Property(name="teamsAppId")
    @JsonIgnore
    public Optional<String> getTeamsAppId() {
        return Optional.ofNullable(teamsAppId);
    }

    public TeamsAppUpgradedEventMessageDetail withTeamsAppId(String teamsAppId) {
        TeamsAppUpgradedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsAppUpgradedEventMessageDetail");
        _x.teamsAppId = teamsAppId;
        return _x;
    }

    public TeamsAppUpgradedEventMessageDetail withUnmappedField(String name, Object value) {
        TeamsAppUpgradedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsAppUpgradedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet initiator;
        private String teamsAppDisplayName;
        private String teamsAppId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder teamsAppDisplayName(String teamsAppDisplayName) {
            this.teamsAppDisplayName = teamsAppDisplayName;
            this.changedFields = changedFields.add("teamsAppDisplayName");
            return this;
        }

        public Builder teamsAppId(String teamsAppId) {
            this.teamsAppId = teamsAppId;
            this.changedFields = changedFields.add("teamsAppId");
            return this;
        }

        public TeamsAppUpgradedEventMessageDetail build() {
            TeamsAppUpgradedEventMessageDetail _x = new TeamsAppUpgradedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamsAppUpgradedEventMessageDetail";
            _x.initiator = initiator;
            _x.teamsAppDisplayName = teamsAppDisplayName;
            _x.teamsAppId = teamsAppId;
            return _x;
        }
    }

    private TeamsAppUpgradedEventMessageDetail _copy() {
        TeamsAppUpgradedEventMessageDetail _x = new TeamsAppUpgradedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.initiator = initiator;
        _x.teamsAppDisplayName = teamsAppDisplayName;
        _x.teamsAppId = teamsAppId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsAppUpgradedEventMessageDetail[");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("teamsAppDisplayName=");
        b.append(this.teamsAppDisplayName);
        b.append(", ");
        b.append("teamsAppId=");
        b.append(this.teamsAppId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
