package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "guestsCount", 
    "membersCount", 
    "ownersCount"})
@JsonInclude(Include.NON_NULL)
public class TeamSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("guestsCount")
    protected Integer guestsCount;

    @JsonProperty("membersCount")
    protected Integer membersCount;

    @JsonProperty("ownersCount")
    protected Integer ownersCount;

    protected TeamSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamSummary";
    }

    @Property(name="guestsCount")
    @JsonIgnore
    public Optional<Integer> getGuestsCount() {
        return Optional.ofNullable(guestsCount);
    }

    public TeamSummary withGuestsCount(Integer guestsCount) {
        TeamSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamSummary");
        _x.guestsCount = guestsCount;
        return _x;
    }

    @Property(name="membersCount")
    @JsonIgnore
    public Optional<Integer> getMembersCount() {
        return Optional.ofNullable(membersCount);
    }

    public TeamSummary withMembersCount(Integer membersCount) {
        TeamSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamSummary");
        _x.membersCount = membersCount;
        return _x;
    }

    @Property(name="ownersCount")
    @JsonIgnore
    public Optional<Integer> getOwnersCount() {
        return Optional.ofNullable(ownersCount);
    }

    public TeamSummary withOwnersCount(Integer ownersCount) {
        TeamSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamSummary");
        _x.ownersCount = ownersCount;
        return _x;
    }

    public TeamSummary withUnmappedField(String name, Object value) {
        TeamSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer guestsCount;
        private Integer membersCount;
        private Integer ownersCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder guestsCount(Integer guestsCount) {
            this.guestsCount = guestsCount;
            this.changedFields = changedFields.add("guestsCount");
            return this;
        }

        public Builder membersCount(Integer membersCount) {
            this.membersCount = membersCount;
            this.changedFields = changedFields.add("membersCount");
            return this;
        }

        public Builder ownersCount(Integer ownersCount) {
            this.ownersCount = ownersCount;
            this.changedFields = changedFields.add("ownersCount");
            return this;
        }

        public TeamSummary build() {
            TeamSummary _x = new TeamSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamSummary";
            _x.guestsCount = guestsCount;
            _x.membersCount = membersCount;
            _x.ownersCount = ownersCount;
            return _x;
        }
    }

    private TeamSummary _copy() {
        TeamSummary _x = new TeamSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.guestsCount = guestsCount;
        _x.membersCount = membersCount;
        _x.ownersCount = ownersCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamSummary[");
        b.append("guestsCount=");
        b.append(this.guestsCount);
        b.append(", ");
        b.append("membersCount=");
        b.append(this.membersCount);
        b.append(", ");
        b.append("ownersCount=");
        b.append(this.ownersCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
