package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowChannelMentions", 
    "allowOwnerDeleteMessages", 
    "allowTeamMentions", 
    "allowUserDeleteMessages", 
    "allowUserEditMessages"})
@JsonInclude(Include.NON_NULL)
public class TeamMessagingSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowChannelMentions")
    protected Boolean allowChannelMentions;

    @JsonProperty("allowOwnerDeleteMessages")
    protected Boolean allowOwnerDeleteMessages;

    @JsonProperty("allowTeamMentions")
    protected Boolean allowTeamMentions;

    @JsonProperty("allowUserDeleteMessages")
    protected Boolean allowUserDeleteMessages;

    @JsonProperty("allowUserEditMessages")
    protected Boolean allowUserEditMessages;

    protected TeamMessagingSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamMessagingSettings";
    }

    @Property(name="allowChannelMentions")
    @JsonIgnore
    public Optional<Boolean> getAllowChannelMentions() {
        return Optional.ofNullable(allowChannelMentions);
    }

    public TeamMessagingSettings withAllowChannelMentions(Boolean allowChannelMentions) {
        TeamMessagingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMessagingSettings");
        _x.allowChannelMentions = allowChannelMentions;
        return _x;
    }

    @Property(name="allowOwnerDeleteMessages")
    @JsonIgnore
    public Optional<Boolean> getAllowOwnerDeleteMessages() {
        return Optional.ofNullable(allowOwnerDeleteMessages);
    }

    public TeamMessagingSettings withAllowOwnerDeleteMessages(Boolean allowOwnerDeleteMessages) {
        TeamMessagingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMessagingSettings");
        _x.allowOwnerDeleteMessages = allowOwnerDeleteMessages;
        return _x;
    }

    @Property(name="allowTeamMentions")
    @JsonIgnore
    public Optional<Boolean> getAllowTeamMentions() {
        return Optional.ofNullable(allowTeamMentions);
    }

    public TeamMessagingSettings withAllowTeamMentions(Boolean allowTeamMentions) {
        TeamMessagingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMessagingSettings");
        _x.allowTeamMentions = allowTeamMentions;
        return _x;
    }

    @Property(name="allowUserDeleteMessages")
    @JsonIgnore
    public Optional<Boolean> getAllowUserDeleteMessages() {
        return Optional.ofNullable(allowUserDeleteMessages);
    }

    public TeamMessagingSettings withAllowUserDeleteMessages(Boolean allowUserDeleteMessages) {
        TeamMessagingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMessagingSettings");
        _x.allowUserDeleteMessages = allowUserDeleteMessages;
        return _x;
    }

    @Property(name="allowUserEditMessages")
    @JsonIgnore
    public Optional<Boolean> getAllowUserEditMessages() {
        return Optional.ofNullable(allowUserEditMessages);
    }

    public TeamMessagingSettings withAllowUserEditMessages(Boolean allowUserEditMessages) {
        TeamMessagingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMessagingSettings");
        _x.allowUserEditMessages = allowUserEditMessages;
        return _x;
    }

    public TeamMessagingSettings withUnmappedField(String name, Object value) {
        TeamMessagingSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowChannelMentions;
        private Boolean allowOwnerDeleteMessages;
        private Boolean allowTeamMentions;
        private Boolean allowUserDeleteMessages;
        private Boolean allowUserEditMessages;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowChannelMentions(Boolean allowChannelMentions) {
            this.allowChannelMentions = allowChannelMentions;
            this.changedFields = changedFields.add("allowChannelMentions");
            return this;
        }

        public Builder allowOwnerDeleteMessages(Boolean allowOwnerDeleteMessages) {
            this.allowOwnerDeleteMessages = allowOwnerDeleteMessages;
            this.changedFields = changedFields.add("allowOwnerDeleteMessages");
            return this;
        }

        public Builder allowTeamMentions(Boolean allowTeamMentions) {
            this.allowTeamMentions = allowTeamMentions;
            this.changedFields = changedFields.add("allowTeamMentions");
            return this;
        }

        public Builder allowUserDeleteMessages(Boolean allowUserDeleteMessages) {
            this.allowUserDeleteMessages = allowUserDeleteMessages;
            this.changedFields = changedFields.add("allowUserDeleteMessages");
            return this;
        }

        public Builder allowUserEditMessages(Boolean allowUserEditMessages) {
            this.allowUserEditMessages = allowUserEditMessages;
            this.changedFields = changedFields.add("allowUserEditMessages");
            return this;
        }

        public TeamMessagingSettings build() {
            TeamMessagingSettings _x = new TeamMessagingSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamMessagingSettings";
            _x.allowChannelMentions = allowChannelMentions;
            _x.allowOwnerDeleteMessages = allowOwnerDeleteMessages;
            _x.allowTeamMentions = allowTeamMentions;
            _x.allowUserDeleteMessages = allowUserDeleteMessages;
            _x.allowUserEditMessages = allowUserEditMessages;
            return _x;
        }
    }

    private TeamMessagingSettings _copy() {
        TeamMessagingSettings _x = new TeamMessagingSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowChannelMentions = allowChannelMentions;
        _x.allowOwnerDeleteMessages = allowOwnerDeleteMessages;
        _x.allowTeamMentions = allowTeamMentions;
        _x.allowUserDeleteMessages = allowUserDeleteMessages;
        _x.allowUserEditMessages = allowUserEditMessages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamMessagingSettings[");
        b.append("allowChannelMentions=");
        b.append(this.allowChannelMentions);
        b.append(", ");
        b.append("allowOwnerDeleteMessages=");
        b.append(this.allowOwnerDeleteMessages);
        b.append(", ");
        b.append("allowTeamMentions=");
        b.append(this.allowTeamMentions);
        b.append(", ");
        b.append("allowUserDeleteMessages=");
        b.append(this.allowUserDeleteMessages);
        b.append(", ");
        b.append("allowUserEditMessages=");
        b.append(this.allowUserEditMessages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
