package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "initiator", 
    "teamId"})
@JsonInclude(Include.NON_NULL)
public class TeamJoiningEnabledEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("teamId")
    protected String teamId;

    protected TeamJoiningEnabledEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamJoiningEnabledEventMessageDetail";
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public TeamJoiningEnabledEventMessageDetail withInitiator(IdentitySet initiator) {
        TeamJoiningEnabledEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamJoiningEnabledEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="teamId")
    @JsonIgnore
    public Optional<String> getTeamId() {
        return Optional.ofNullable(teamId);
    }

    public TeamJoiningEnabledEventMessageDetail withTeamId(String teamId) {
        TeamJoiningEnabledEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamJoiningEnabledEventMessageDetail");
        _x.teamId = teamId;
        return _x;
    }

    public TeamJoiningEnabledEventMessageDetail withUnmappedField(String name, Object value) {
        TeamJoiningEnabledEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamJoiningEnabledEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet initiator;
        private String teamId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder teamId(String teamId) {
            this.teamId = teamId;
            this.changedFields = changedFields.add("teamId");
            return this;
        }

        public TeamJoiningEnabledEventMessageDetail build() {
            TeamJoiningEnabledEventMessageDetail _x = new TeamJoiningEnabledEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamJoiningEnabledEventMessageDetail";
            _x.initiator = initiator;
            _x.teamId = teamId;
            return _x;
        }
    }

    private TeamJoiningEnabledEventMessageDetail _copy() {
        TeamJoiningEnabledEventMessageDetail _x = new TeamJoiningEnabledEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.initiator = initiator;
        _x.teamId = teamId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamJoiningEnabledEventMessageDetail[");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("teamId=");
        b.append(this.teamId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
