package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowCreateUpdateChannels", 
    "allowDeleteChannels"})
@JsonInclude(Include.NON_NULL)
public class TeamGuestSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowCreateUpdateChannels")
    protected Boolean allowCreateUpdateChannels;

    @JsonProperty("allowDeleteChannels")
    protected Boolean allowDeleteChannels;

    protected TeamGuestSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamGuestSettings";
    }

    @Property(name="allowCreateUpdateChannels")
    @JsonIgnore
    public Optional<Boolean> getAllowCreateUpdateChannels() {
        return Optional.ofNullable(allowCreateUpdateChannels);
    }

    public TeamGuestSettings withAllowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
        TeamGuestSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamGuestSettings");
        _x.allowCreateUpdateChannels = allowCreateUpdateChannels;
        return _x;
    }

    @Property(name="allowDeleteChannels")
    @JsonIgnore
    public Optional<Boolean> getAllowDeleteChannels() {
        return Optional.ofNullable(allowDeleteChannels);
    }

    public TeamGuestSettings withAllowDeleteChannels(Boolean allowDeleteChannels) {
        TeamGuestSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamGuestSettings");
        _x.allowDeleteChannels = allowDeleteChannels;
        return _x;
    }

    public TeamGuestSettings withUnmappedField(String name, Object value) {
        TeamGuestSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowCreateUpdateChannels;
        private Boolean allowDeleteChannels;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
            this.allowCreateUpdateChannels = allowCreateUpdateChannels;
            this.changedFields = changedFields.add("allowCreateUpdateChannels");
            return this;
        }

        public Builder allowDeleteChannels(Boolean allowDeleteChannels) {
            this.allowDeleteChannels = allowDeleteChannels;
            this.changedFields = changedFields.add("allowDeleteChannels");
            return this;
        }

        public TeamGuestSettings build() {
            TeamGuestSettings _x = new TeamGuestSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamGuestSettings";
            _x.allowCreateUpdateChannels = allowCreateUpdateChannels;
            _x.allowDeleteChannels = allowDeleteChannels;
            return _x;
        }
    }

    private TeamGuestSettings _copy() {
        TeamGuestSettings _x = new TeamGuestSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowCreateUpdateChannels = allowCreateUpdateChannels;
        _x.allowDeleteChannels = allowDeleteChannels;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamGuestSettings[");
        b.append("allowCreateUpdateChannels=");
        b.append(this.allowCreateUpdateChannels);
        b.append(", ");
        b.append("allowDeleteChannels=");
        b.append(this.allowDeleteChannels);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
