package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "showInTeamsSearchAndSuggestions"})
@JsonInclude(Include.NON_NULL)
public class TeamDiscoverySettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("showInTeamsSearchAndSuggestions")
    protected Boolean showInTeamsSearchAndSuggestions;

    protected TeamDiscoverySettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamDiscoverySettings";
    }

    @Property(name="showInTeamsSearchAndSuggestions")
    @JsonIgnore
    public Optional<Boolean> getShowInTeamsSearchAndSuggestions() {
        return Optional.ofNullable(showInTeamsSearchAndSuggestions);
    }

    public TeamDiscoverySettings withShowInTeamsSearchAndSuggestions(Boolean showInTeamsSearchAndSuggestions) {
        TeamDiscoverySettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamDiscoverySettings");
        _x.showInTeamsSearchAndSuggestions = showInTeamsSearchAndSuggestions;
        return _x;
    }

    public TeamDiscoverySettings withUnmappedField(String name, Object value) {
        TeamDiscoverySettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean showInTeamsSearchAndSuggestions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder showInTeamsSearchAndSuggestions(Boolean showInTeamsSearchAndSuggestions) {
            this.showInTeamsSearchAndSuggestions = showInTeamsSearchAndSuggestions;
            this.changedFields = changedFields.add("showInTeamsSearchAndSuggestions");
            return this;
        }

        public TeamDiscoverySettings build() {
            TeamDiscoverySettings _x = new TeamDiscoverySettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamDiscoverySettings";
            _x.showInTeamsSearchAndSuggestions = showInTeamsSearchAndSuggestions;
            return _x;
        }
    }

    private TeamDiscoverySettings _copy() {
        TeamDiscoverySettings _x = new TeamDiscoverySettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.showInTeamsSearchAndSuggestions = showInTeamsSearchAndSuggestions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamDiscoverySettings[");
        b.append("showInTeamsSearchAndSuggestions=");
        b.append(this.showInTeamsSearchAndSuggestions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
