package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "initiator", 
    "teamDescription", 
    "teamDisplayName", 
    "teamId"})
@JsonInclude(Include.NON_NULL)
public class TeamCreatedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("teamDescription")
    protected String teamDescription;

    @JsonProperty("teamDisplayName")
    protected String teamDisplayName;

    @JsonProperty("teamId")
    protected String teamId;

    protected TeamCreatedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamCreatedEventMessageDetail";
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public TeamCreatedEventMessageDetail withInitiator(IdentitySet initiator) {
        TeamCreatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamCreatedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="teamDescription")
    @JsonIgnore
    public Optional<String> getTeamDescription() {
        return Optional.ofNullable(teamDescription);
    }

    public TeamCreatedEventMessageDetail withTeamDescription(String teamDescription) {
        TeamCreatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamCreatedEventMessageDetail");
        _x.teamDescription = teamDescription;
        return _x;
    }

    @Property(name="teamDisplayName")
    @JsonIgnore
    public Optional<String> getTeamDisplayName() {
        return Optional.ofNullable(teamDisplayName);
    }

    public TeamCreatedEventMessageDetail withTeamDisplayName(String teamDisplayName) {
        TeamCreatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamCreatedEventMessageDetail");
        _x.teamDisplayName = teamDisplayName;
        return _x;
    }

    @Property(name="teamId")
    @JsonIgnore
    public Optional<String> getTeamId() {
        return Optional.ofNullable(teamId);
    }

    public TeamCreatedEventMessageDetail withTeamId(String teamId) {
        TeamCreatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamCreatedEventMessageDetail");
        _x.teamId = teamId;
        return _x;
    }

    public TeamCreatedEventMessageDetail withUnmappedField(String name, Object value) {
        TeamCreatedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamCreatedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet initiator;
        private String teamDescription;
        private String teamDisplayName;
        private String teamId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder teamDescription(String teamDescription) {
            this.teamDescription = teamDescription;
            this.changedFields = changedFields.add("teamDescription");
            return this;
        }

        public Builder teamDisplayName(String teamDisplayName) {
            this.teamDisplayName = teamDisplayName;
            this.changedFields = changedFields.add("teamDisplayName");
            return this;
        }

        public Builder teamId(String teamId) {
            this.teamId = teamId;
            this.changedFields = changedFields.add("teamId");
            return this;
        }

        public TeamCreatedEventMessageDetail build() {
            TeamCreatedEventMessageDetail _x = new TeamCreatedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamCreatedEventMessageDetail";
            _x.initiator = initiator;
            _x.teamDescription = teamDescription;
            _x.teamDisplayName = teamDisplayName;
            _x.teamId = teamId;
            return _x;
        }
    }

    private TeamCreatedEventMessageDetail _copy() {
        TeamCreatedEventMessageDetail _x = new TeamCreatedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.initiator = initiator;
        _x.teamDescription = teamDescription;
        _x.teamDisplayName = teamDisplayName;
        _x.teamId = teamId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamCreatedEventMessageDetail[");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("teamDescription=");
        b.append(this.teamDescription);
        b.append(", ");
        b.append("teamDisplayName=");
        b.append(this.teamDisplayName);
        b.append(", ");
        b.append("teamId=");
        b.append(this.teamId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
