package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SynchronizationStatusCode;

@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "countSuccessiveCompleteFailures", 
    "escrowsPruned", 
    "lastExecution", 
    "lastSuccessfulExecution", 
    "lastSuccessfulExecutionWithExports", 
    "progress", 
    "quarantine", 
    "steadyStateFirstAchievedTime", 
    "steadyStateLastAchievedTime", 
    "synchronizedEntryCountByType", 
    "troubleshootingUrl"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("code")
    protected SynchronizationStatusCode code;

    @JsonProperty("countSuccessiveCompleteFailures")
    protected Long countSuccessiveCompleteFailures;

    @JsonProperty("escrowsPruned")
    protected Boolean escrowsPruned;

    @JsonProperty("lastExecution")
    protected SynchronizationTaskExecution lastExecution;

    @JsonProperty("lastSuccessfulExecution")
    protected SynchronizationTaskExecution lastSuccessfulExecution;

    @JsonProperty("lastSuccessfulExecutionWithExports")
    protected SynchronizationTaskExecution lastSuccessfulExecutionWithExports;

    @JsonProperty("progress")
    protected List<SynchronizationProgress> progress;

    @JsonProperty("progress@nextLink")
    protected String progressNextLink;

    @JsonProperty("quarantine")
    protected SynchronizationQuarantine quarantine;

    @JsonProperty("steadyStateFirstAchievedTime")
    protected OffsetDateTime steadyStateFirstAchievedTime;

    @JsonProperty("steadyStateLastAchievedTime")
    protected OffsetDateTime steadyStateLastAchievedTime;

    @JsonProperty("synchronizedEntryCountByType")
    protected List<StringKeyLongValuePair> synchronizedEntryCountByType;

    @JsonProperty("synchronizedEntryCountByType@nextLink")
    protected String synchronizedEntryCountByTypeNextLink;

    @JsonProperty("troubleshootingUrl")
    protected String troubleshootingUrl;

    protected SynchronizationStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationStatus";
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<SynchronizationStatusCode> getCode() {
        return Optional.ofNullable(code);
    }

    public SynchronizationStatus withCode(SynchronizationStatusCode code) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.code = code;
        return _x;
    }

    @Property(name="countSuccessiveCompleteFailures")
    @JsonIgnore
    public Optional<Long> getCountSuccessiveCompleteFailures() {
        return Optional.ofNullable(countSuccessiveCompleteFailures);
    }

    public SynchronizationStatus withCountSuccessiveCompleteFailures(Long countSuccessiveCompleteFailures) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.countSuccessiveCompleteFailures = countSuccessiveCompleteFailures;
        return _x;
    }

    @Property(name="escrowsPruned")
    @JsonIgnore
    public Optional<Boolean> getEscrowsPruned() {
        return Optional.ofNullable(escrowsPruned);
    }

    public SynchronizationStatus withEscrowsPruned(Boolean escrowsPruned) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.escrowsPruned = escrowsPruned;
        return _x;
    }

    @Property(name="lastExecution")
    @JsonIgnore
    public Optional<SynchronizationTaskExecution> getLastExecution() {
        return Optional.ofNullable(lastExecution);
    }

    public SynchronizationStatus withLastExecution(SynchronizationTaskExecution lastExecution) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.lastExecution = lastExecution;
        return _x;
    }

    @Property(name="lastSuccessfulExecution")
    @JsonIgnore
    public Optional<SynchronizationTaskExecution> getLastSuccessfulExecution() {
        return Optional.ofNullable(lastSuccessfulExecution);
    }

    public SynchronizationStatus withLastSuccessfulExecution(SynchronizationTaskExecution lastSuccessfulExecution) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.lastSuccessfulExecution = lastSuccessfulExecution;
        return _x;
    }

    @Property(name="lastSuccessfulExecutionWithExports")
    @JsonIgnore
    public Optional<SynchronizationTaskExecution> getLastSuccessfulExecutionWithExports() {
        return Optional.ofNullable(lastSuccessfulExecutionWithExports);
    }

    public SynchronizationStatus withLastSuccessfulExecutionWithExports(SynchronizationTaskExecution lastSuccessfulExecutionWithExports) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.lastSuccessfulExecutionWithExports = lastSuccessfulExecutionWithExports;
        return _x;
    }

    @Property(name="progress")
    @JsonIgnore
    public CollectionPage<SynchronizationProgress> getProgress() {
        return new CollectionPage<SynchronizationProgress>(contextPath, SynchronizationProgress.class, this.progress, Optional.ofNullable(progressNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="progress")
    @JsonIgnore
    public CollectionPage<SynchronizationProgress> getProgress(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationProgress>(contextPath, SynchronizationProgress.class, this.progress, Optional.ofNullable(progressNextLink), Collections.emptyList(), options);
    }

    @Property(name="quarantine")
    @JsonIgnore
    public Optional<SynchronizationQuarantine> getQuarantine() {
        return Optional.ofNullable(quarantine);
    }

    public SynchronizationStatus withQuarantine(SynchronizationQuarantine quarantine) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.quarantine = quarantine;
        return _x;
    }

    @Property(name="steadyStateFirstAchievedTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSteadyStateFirstAchievedTime() {
        return Optional.ofNullable(steadyStateFirstAchievedTime);
    }

    public SynchronizationStatus withSteadyStateFirstAchievedTime(OffsetDateTime steadyStateFirstAchievedTime) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.steadyStateFirstAchievedTime = steadyStateFirstAchievedTime;
        return _x;
    }

    @Property(name="steadyStateLastAchievedTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSteadyStateLastAchievedTime() {
        return Optional.ofNullable(steadyStateLastAchievedTime);
    }

    public SynchronizationStatus withSteadyStateLastAchievedTime(OffsetDateTime steadyStateLastAchievedTime) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.steadyStateLastAchievedTime = steadyStateLastAchievedTime;
        return _x;
    }

    @Property(name="synchronizedEntryCountByType")
    @JsonIgnore
    public CollectionPage<StringKeyLongValuePair> getSynchronizedEntryCountByType() {
        return new CollectionPage<StringKeyLongValuePair>(contextPath, StringKeyLongValuePair.class, this.synchronizedEntryCountByType, Optional.ofNullable(synchronizedEntryCountByTypeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="synchronizedEntryCountByType")
    @JsonIgnore
    public CollectionPage<StringKeyLongValuePair> getSynchronizedEntryCountByType(HttpRequestOptions options) {
        return new CollectionPage<StringKeyLongValuePair>(contextPath, StringKeyLongValuePair.class, this.synchronizedEntryCountByType, Optional.ofNullable(synchronizedEntryCountByTypeNextLink), Collections.emptyList(), options);
    }

    @Property(name="troubleshootingUrl")
    @JsonIgnore
    public Optional<String> getTroubleshootingUrl() {
        return Optional.ofNullable(troubleshootingUrl);
    }

    public SynchronizationStatus withTroubleshootingUrl(String troubleshootingUrl) {
        SynchronizationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationStatus");
        _x.troubleshootingUrl = troubleshootingUrl;
        return _x;
    }

    public SynchronizationStatus withUnmappedField(String name, Object value) {
        SynchronizationStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SynchronizationStatusCode code;
        private Long countSuccessiveCompleteFailures;
        private Boolean escrowsPruned;
        private SynchronizationTaskExecution lastExecution;
        private SynchronizationTaskExecution lastSuccessfulExecution;
        private SynchronizationTaskExecution lastSuccessfulExecutionWithExports;
        private List<SynchronizationProgress> progress;
        private String progressNextLink;
        private SynchronizationQuarantine quarantine;
        private OffsetDateTime steadyStateFirstAchievedTime;
        private OffsetDateTime steadyStateLastAchievedTime;
        private List<StringKeyLongValuePair> synchronizedEntryCountByType;
        private String synchronizedEntryCountByTypeNextLink;
        private String troubleshootingUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder code(SynchronizationStatusCode code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder countSuccessiveCompleteFailures(Long countSuccessiveCompleteFailures) {
            this.countSuccessiveCompleteFailures = countSuccessiveCompleteFailures;
            this.changedFields = changedFields.add("countSuccessiveCompleteFailures");
            return this;
        }

        public Builder escrowsPruned(Boolean escrowsPruned) {
            this.escrowsPruned = escrowsPruned;
            this.changedFields = changedFields.add("escrowsPruned");
            return this;
        }

        public Builder lastExecution(SynchronizationTaskExecution lastExecution) {
            this.lastExecution = lastExecution;
            this.changedFields = changedFields.add("lastExecution");
            return this;
        }

        public Builder lastSuccessfulExecution(SynchronizationTaskExecution lastSuccessfulExecution) {
            this.lastSuccessfulExecution = lastSuccessfulExecution;
            this.changedFields = changedFields.add("lastSuccessfulExecution");
            return this;
        }

        public Builder lastSuccessfulExecutionWithExports(SynchronizationTaskExecution lastSuccessfulExecutionWithExports) {
            this.lastSuccessfulExecutionWithExports = lastSuccessfulExecutionWithExports;
            this.changedFields = changedFields.add("lastSuccessfulExecutionWithExports");
            return this;
        }

        public Builder progress(List<SynchronizationProgress> progress) {
            this.progress = progress;
            this.changedFields = changedFields.add("progress");
            return this;
        }

        public Builder progress(SynchronizationProgress... progress) {
            return progress(Arrays.asList(progress));
        }

        public Builder progressNextLink(String progressNextLink) {
            this.progressNextLink = progressNextLink;
            this.changedFields = changedFields.add("progress");
            return this;
        }

        public Builder quarantine(SynchronizationQuarantine quarantine) {
            this.quarantine = quarantine;
            this.changedFields = changedFields.add("quarantine");
            return this;
        }

        public Builder steadyStateFirstAchievedTime(OffsetDateTime steadyStateFirstAchievedTime) {
            this.steadyStateFirstAchievedTime = steadyStateFirstAchievedTime;
            this.changedFields = changedFields.add("steadyStateFirstAchievedTime");
            return this;
        }

        public Builder steadyStateLastAchievedTime(OffsetDateTime steadyStateLastAchievedTime) {
            this.steadyStateLastAchievedTime = steadyStateLastAchievedTime;
            this.changedFields = changedFields.add("steadyStateLastAchievedTime");
            return this;
        }

        public Builder synchronizedEntryCountByType(List<StringKeyLongValuePair> synchronizedEntryCountByType) {
            this.synchronizedEntryCountByType = synchronizedEntryCountByType;
            this.changedFields = changedFields.add("synchronizedEntryCountByType");
            return this;
        }

        public Builder synchronizedEntryCountByType(StringKeyLongValuePair... synchronizedEntryCountByType) {
            return synchronizedEntryCountByType(Arrays.asList(synchronizedEntryCountByType));
        }

        public Builder synchronizedEntryCountByTypeNextLink(String synchronizedEntryCountByTypeNextLink) {
            this.synchronizedEntryCountByTypeNextLink = synchronizedEntryCountByTypeNextLink;
            this.changedFields = changedFields.add("synchronizedEntryCountByType");
            return this;
        }

        public Builder troubleshootingUrl(String troubleshootingUrl) {
            this.troubleshootingUrl = troubleshootingUrl;
            this.changedFields = changedFields.add("troubleshootingUrl");
            return this;
        }

        public SynchronizationStatus build() {
            SynchronizationStatus _x = new SynchronizationStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronizationStatus";
            _x.code = code;
            _x.countSuccessiveCompleteFailures = countSuccessiveCompleteFailures;
            _x.escrowsPruned = escrowsPruned;
            _x.lastExecution = lastExecution;
            _x.lastSuccessfulExecution = lastSuccessfulExecution;
            _x.lastSuccessfulExecutionWithExports = lastSuccessfulExecutionWithExports;
            _x.progress = progress;
            _x.progressNextLink = progressNextLink;
            _x.quarantine = quarantine;
            _x.steadyStateFirstAchievedTime = steadyStateFirstAchievedTime;
            _x.steadyStateLastAchievedTime = steadyStateLastAchievedTime;
            _x.synchronizedEntryCountByType = synchronizedEntryCountByType;
            _x.synchronizedEntryCountByTypeNextLink = synchronizedEntryCountByTypeNextLink;
            _x.troubleshootingUrl = troubleshootingUrl;
            return _x;
        }
    }

    private SynchronizationStatus _copy() {
        SynchronizationStatus _x = new SynchronizationStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.code = code;
        _x.countSuccessiveCompleteFailures = countSuccessiveCompleteFailures;
        _x.escrowsPruned = escrowsPruned;
        _x.lastExecution = lastExecution;
        _x.lastSuccessfulExecution = lastSuccessfulExecution;
        _x.lastSuccessfulExecutionWithExports = lastSuccessfulExecutionWithExports;
        _x.progress = progress;
        _x.quarantine = quarantine;
        _x.steadyStateFirstAchievedTime = steadyStateFirstAchievedTime;
        _x.steadyStateLastAchievedTime = steadyStateLastAchievedTime;
        _x.synchronizedEntryCountByType = synchronizedEntryCountByType;
        _x.troubleshootingUrl = troubleshootingUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationStatus[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("countSuccessiveCompleteFailures=");
        b.append(this.countSuccessiveCompleteFailures);
        b.append(", ");
        b.append("escrowsPruned=");
        b.append(this.escrowsPruned);
        b.append(", ");
        b.append("lastExecution=");
        b.append(this.lastExecution);
        b.append(", ");
        b.append("lastSuccessfulExecution=");
        b.append(this.lastSuccessfulExecution);
        b.append(", ");
        b.append("lastSuccessfulExecutionWithExports=");
        b.append(this.lastSuccessfulExecutionWithExports);
        b.append(", ");
        b.append("progress=");
        b.append(this.progress);
        b.append(", ");
        b.append("quarantine=");
        b.append(this.quarantine);
        b.append(", ");
        b.append("steadyStateFirstAchievedTime=");
        b.append(this.steadyStateFirstAchievedTime);
        b.append(", ");
        b.append("steadyStateLastAchievedTime=");
        b.append(this.steadyStateLastAchievedTime);
        b.append(", ");
        b.append("synchronizedEntryCountByType=");
        b.append(this.synchronizedEntryCountByType);
        b.append(", ");
        b.append("troubleshootingUrl=");
        b.append(this.troubleshootingUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
