package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "completedUnits", 
    "progressObservationDateTime", 
    "totalUnits", 
    "units"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationProgress implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("completedUnits")
    protected Long completedUnits;

    @JsonProperty("progressObservationDateTime")
    protected OffsetDateTime progressObservationDateTime;

    @JsonProperty("totalUnits")
    protected Long totalUnits;

    @JsonProperty("units")
    protected String units;

    protected SynchronizationProgress() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationProgress";
    }

    @Property(name="completedUnits")
    @JsonIgnore
    public Optional<Long> getCompletedUnits() {
        return Optional.ofNullable(completedUnits);
    }

    public SynchronizationProgress withCompletedUnits(Long completedUnits) {
        SynchronizationProgress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationProgress");
        _x.completedUnits = completedUnits;
        return _x;
    }

    @Property(name="progressObservationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getProgressObservationDateTime() {
        return Optional.ofNullable(progressObservationDateTime);
    }

    public SynchronizationProgress withProgressObservationDateTime(OffsetDateTime progressObservationDateTime) {
        SynchronizationProgress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationProgress");
        _x.progressObservationDateTime = progressObservationDateTime;
        return _x;
    }

    @Property(name="totalUnits")
    @JsonIgnore
    public Optional<Long> getTotalUnits() {
        return Optional.ofNullable(totalUnits);
    }

    public SynchronizationProgress withTotalUnits(Long totalUnits) {
        SynchronizationProgress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationProgress");
        _x.totalUnits = totalUnits;
        return _x;
    }

    @Property(name="units")
    @JsonIgnore
    public Optional<String> getUnits() {
        return Optional.ofNullable(units);
    }

    public SynchronizationProgress withUnits(String units) {
        SynchronizationProgress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationProgress");
        _x.units = units;
        return _x;
    }

    public SynchronizationProgress withUnmappedField(String name, Object value) {
        SynchronizationProgress _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long completedUnits;
        private OffsetDateTime progressObservationDateTime;
        private Long totalUnits;
        private String units;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder completedUnits(Long completedUnits) {
            this.completedUnits = completedUnits;
            this.changedFields = changedFields.add("completedUnits");
            return this;
        }

        public Builder progressObservationDateTime(OffsetDateTime progressObservationDateTime) {
            this.progressObservationDateTime = progressObservationDateTime;
            this.changedFields = changedFields.add("progressObservationDateTime");
            return this;
        }

        public Builder totalUnits(Long totalUnits) {
            this.totalUnits = totalUnits;
            this.changedFields = changedFields.add("totalUnits");
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            this.changedFields = changedFields.add("units");
            return this;
        }

        public SynchronizationProgress build() {
            SynchronizationProgress _x = new SynchronizationProgress();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronizationProgress";
            _x.completedUnits = completedUnits;
            _x.progressObservationDateTime = progressObservationDateTime;
            _x.totalUnits = totalUnits;
            _x.units = units;
            return _x;
        }
    }

    private SynchronizationProgress _copy() {
        SynchronizationProgress _x = new SynchronizationProgress();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.completedUnits = completedUnits;
        _x.progressObservationDateTime = progressObservationDateTime;
        _x.totalUnits = totalUnits;
        _x.units = units;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationProgress[");
        b.append("completedUnits=");
        b.append(this.completedUnits);
        b.append(", ");
        b.append("progressObservationDateTime=");
        b.append(this.progressObservationDateTime);
        b.append(", ");
        b.append("totalUnits=");
        b.append(this.totalUnits);
        b.append(", ");
        b.append("units=");
        b.append(this.units);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
