package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The suggestedEnrollmentLimit resource represents the suggested enrollment limit
 * when given an enrollment type.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "suggestedDailyLimit"})
@JsonInclude(Include.NON_NULL)
public class SuggestedEnrollmentLimit implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("suggestedDailyLimit")
    protected Integer suggestedDailyLimit;

    protected SuggestedEnrollmentLimit() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.suggestedEnrollmentLimit";
    }

    /**
     * <i>“The suggested enrollment limit within a day”</i>
     * 
     * @return property suggestedDailyLimit
     */
    @Property(name="suggestedDailyLimit")
    @JsonIgnore
    public Optional<Integer> getSuggestedDailyLimit() {
        return Optional.ofNullable(suggestedDailyLimit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * suggestedDailyLimit} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The suggested enrollment limit within a day”</i>
     * 
     * @param suggestedDailyLimit
     *            new value of {@code suggestedDailyLimit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code suggestedDailyLimit} field changed
     */
    public SuggestedEnrollmentLimit withSuggestedDailyLimit(Integer suggestedDailyLimit) {
        SuggestedEnrollmentLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.suggestedEnrollmentLimit");
        _x.suggestedDailyLimit = suggestedDailyLimit;
        return _x;
    }

    public SuggestedEnrollmentLimit withUnmappedField(String name, Object value) {
        SuggestedEnrollmentLimit _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer suggestedDailyLimit;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The suggested enrollment limit within a day”</i>
         * 
         * @param suggestedDailyLimit
         *            value of {@code suggestedDailyLimit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder suggestedDailyLimit(Integer suggestedDailyLimit) {
            this.suggestedDailyLimit = suggestedDailyLimit;
            this.changedFields = changedFields.add("suggestedDailyLimit");
            return this;
        }

        public SuggestedEnrollmentLimit build() {
            SuggestedEnrollmentLimit _x = new SuggestedEnrollmentLimit();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.suggestedEnrollmentLimit";
            _x.suggestedDailyLimit = suggestedDailyLimit;
            return _x;
        }
    }

    private SuggestedEnrollmentLimit _copy() {
        SuggestedEnrollmentLimit _x = new SuggestedEnrollmentLimit();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.suggestedDailyLimit = suggestedDailyLimit;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SuggestedEnrollmentLimit[");
        b.append("suggestedDailyLimit=");
        b.append(this.suggestedDailyLimit);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
