package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SubjectRightsRequestStage;
import odata.msgraph.client.beta.enums.SubjectRightsRequestStageStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "changedBy", 
    "eventDateTime", 
    "stage", 
    "stageStatus", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class SubjectRightsRequestHistory implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("changedBy")
    protected IdentitySet changedBy;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    @JsonProperty("stage")
    protected SubjectRightsRequestStage stage;

    @JsonProperty("stageStatus")
    protected SubjectRightsRequestStageStatus stageStatus;

    @JsonProperty("type")
    protected String type;

    protected SubjectRightsRequestHistory() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.subjectRightsRequestHistory";
    }

    @Property(name="changedBy")
    @JsonIgnore
    public Optional<IdentitySet> getChangedBy() {
        return Optional.ofNullable(changedBy);
    }

    public SubjectRightsRequestHistory withChangedBy(IdentitySet changedBy) {
        SubjectRightsRequestHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestHistory");
        _x.changedBy = changedBy;
        return _x;
    }

    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    public SubjectRightsRequestHistory withEventDateTime(OffsetDateTime eventDateTime) {
        SubjectRightsRequestHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestHistory");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    @Property(name="stage")
    @JsonIgnore
    public Optional<SubjectRightsRequestStage> getStage() {
        return Optional.ofNullable(stage);
    }

    public SubjectRightsRequestHistory withStage(SubjectRightsRequestStage stage) {
        SubjectRightsRequestHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestHistory");
        _x.stage = stage;
        return _x;
    }

    @Property(name="stageStatus")
    @JsonIgnore
    public Optional<SubjectRightsRequestStageStatus> getStageStatus() {
        return Optional.ofNullable(stageStatus);
    }

    public SubjectRightsRequestHistory withStageStatus(SubjectRightsRequestStageStatus stageStatus) {
        SubjectRightsRequestHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestHistory");
        _x.stageStatus = stageStatus;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public SubjectRightsRequestHistory withType(String type) {
        SubjectRightsRequestHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestHistory");
        _x.type = type;
        return _x;
    }

    public SubjectRightsRequestHistory withUnmappedField(String name, Object value) {
        SubjectRightsRequestHistory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet changedBy;
        private OffsetDateTime eventDateTime;
        private SubjectRightsRequestStage stage;
        private SubjectRightsRequestStageStatus stageStatus;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder changedBy(IdentitySet changedBy) {
            this.changedBy = changedBy;
            this.changedFields = changedFields.add("changedBy");
            return this;
        }

        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        public Builder stage(SubjectRightsRequestStage stage) {
            this.stage = stage;
            this.changedFields = changedFields.add("stage");
            return this;
        }

        public Builder stageStatus(SubjectRightsRequestStageStatus stageStatus) {
            this.stageStatus = stageStatus;
            this.changedFields = changedFields.add("stageStatus");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public SubjectRightsRequestHistory build() {
            SubjectRightsRequestHistory _x = new SubjectRightsRequestHistory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.subjectRightsRequestHistory";
            _x.changedBy = changedBy;
            _x.eventDateTime = eventDateTime;
            _x.stage = stage;
            _x.stageStatus = stageStatus;
            _x.type = type;
            return _x;
        }
    }

    private SubjectRightsRequestHistory _copy() {
        SubjectRightsRequestHistory _x = new SubjectRightsRequestHistory();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.changedBy = changedBy;
        _x.eventDateTime = eventDateTime;
        _x.stage = stage;
        _x.stageStatus = stageStatus;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubjectRightsRequestHistory[");
        b.append("changedBy=");
        b.append(this.changedBy);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("stage=");
        b.append(this.stage);
        b.append(", ");
        b.append("stageStatus=");
        b.append(this.stageStatus);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
