package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "key", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class StringKeyLongValuePair implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("key")
    protected String key;

    @JsonProperty("value")
    protected Long value;

    protected StringKeyLongValuePair() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.stringKeyLongValuePair";
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public StringKeyLongValuePair withKey(String key) {
        StringKeyLongValuePair _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.stringKeyLongValuePair");
        _x.key = key;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<Long> getValue() {
        return Optional.ofNullable(value);
    }

    public StringKeyLongValuePair withValue(Long value) {
        StringKeyLongValuePair _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.stringKeyLongValuePair");
        _x.value = value;
        return _x;
    }

    public StringKeyLongValuePair withUnmappedField(String name, Object value) {
        StringKeyLongValuePair _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private Long value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public Builder value(Long value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public StringKeyLongValuePair build() {
            StringKeyLongValuePair _x = new StringKeyLongValuePair();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.stringKeyLongValuePair";
            _x.key = key;
            _x.value = value;
            return _x;
        }
    }

    private StringKeyLongValuePair _copy() {
        StringKeyLongValuePair _x = new StringKeyLongValuePair();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.key = key;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StringKeyLongValuePair[");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
