package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Specifies all the Captive network plugins allowed during the IKEv2 AlwaysOn VPN
 * connection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedBundleIdentifiers"})
@JsonInclude(Include.NON_NULL)
public class SpecifiedCaptiveNetworkPlugins implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedBundleIdentifiers")
    protected List<String> allowedBundleIdentifiers;

    @JsonProperty("allowedBundleIdentifiers@nextLink")
    protected String allowedBundleIdentifiersNextLink;

    protected SpecifiedCaptiveNetworkPlugins() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.specifiedCaptiveNetworkPlugins";
    }

    /**
     * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
     * ASN1DN”</i>
     * 
     * @return property allowedBundleIdentifiers
     */
    @Property(name="allowedBundleIdentifiers")
    @JsonIgnore
    public CollectionPage<String> getAllowedBundleIdentifiers() {
        return new CollectionPage<String>(contextPath, String.class, this.allowedBundleIdentifiers, Optional.ofNullable(allowedBundleIdentifiersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
     * ASN1DN”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property allowedBundleIdentifiers
     */
    @Property(name="allowedBundleIdentifiers")
    @JsonIgnore
    public CollectionPage<String> getAllowedBundleIdentifiers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.allowedBundleIdentifiers, Optional.ofNullable(allowedBundleIdentifiersNextLink), Collections.emptyList(), options);
    }

    public SpecifiedCaptiveNetworkPlugins withUnmappedField(String name, Object value) {
        SpecifiedCaptiveNetworkPlugins _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedBundleIdentifiers;
        private String allowedBundleIdentifiersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
         * ASN1DN”</i>
         * 
         * @param allowedBundleIdentifiers
         *            value of {@code allowedBundleIdentifiers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedBundleIdentifiers(List<String> allowedBundleIdentifiers) {
            this.allowedBundleIdentifiers = allowedBundleIdentifiers;
            this.changedFields = changedFields.add("allowedBundleIdentifiers");
            return this;
        }

        /**
         * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
         * ASN1DN”</i>
         * 
         * @param allowedBundleIdentifiers
         *            value of {@code allowedBundleIdentifiers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedBundleIdentifiers(String... allowedBundleIdentifiers) {
            return allowedBundleIdentifiers(Arrays.asList(allowedBundleIdentifiers));
        }

        /**
         * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
         * ASN1DN”</i>
         * 
         * @param allowedBundleIdentifiersNextLink
         *            value of {@code allowedBundleIdentifiers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedBundleIdentifiersNextLink(String allowedBundleIdentifiersNextLink) {
            this.allowedBundleIdentifiersNextLink = allowedBundleIdentifiersNextLink;
            this.changedFields = changedFields.add("allowedBundleIdentifiers");
            return this;
        }

        public SpecifiedCaptiveNetworkPlugins build() {
            SpecifiedCaptiveNetworkPlugins _x = new SpecifiedCaptiveNetworkPlugins();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.specifiedCaptiveNetworkPlugins";
            _x.allowedBundleIdentifiers = allowedBundleIdentifiers;
            _x.allowedBundleIdentifiersNextLink = allowedBundleIdentifiersNextLink;
            return _x;
        }
    }

    private SpecifiedCaptiveNetworkPlugins _copy() {
        SpecifiedCaptiveNetworkPlugins _x = new SpecifiedCaptiveNetworkPlugins();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedBundleIdentifiers = allowedBundleIdentifiers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SpecifiedCaptiveNetworkPlugins[");
        b.append("allowedBundleIdentifiers=");
        b.append(this.allowedBundleIdentifiers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
