package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "languageTag", 
    "timeZone"})
@JsonInclude(Include.NON_NULL)
public class SiteSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("languageTag")
    protected String languageTag;

    @JsonProperty("timeZone")
    protected String timeZone;

    protected SiteSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.siteSettings";
    }

    @Property(name="languageTag")
    @JsonIgnore
    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(languageTag);
    }

    public SiteSettings withLanguageTag(String languageTag) {
        SiteSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.siteSettings");
        _x.languageTag = languageTag;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public SiteSettings withTimeZone(String timeZone) {
        SiteSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.siteSettings");
        _x.timeZone = timeZone;
        return _x;
    }

    public SiteSettings withUnmappedField(String name, Object value) {
        SiteSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String languageTag;
        private String timeZone;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder languageTag(String languageTag) {
            this.languageTag = languageTag;
            this.changedFields = changedFields.add("languageTag");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public SiteSettings build() {
            SiteSettings _x = new SiteSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.siteSettings";
            _x.languageTag = languageTag;
            _x.timeZone = timeZone;
            return _x;
        }
    }

    private SiteSettings _copy() {
        SiteSettings _x = new SiteSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.languageTag = languageTag;
        _x.timeZone = timeZone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SiteSettings[");
        b.append("languageTag=");
        b.append(this.languageTag);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
